/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vnmonitoring.VnMonitoring;
import com.oracle.bmc.vnmonitoring.VnMonitoringAsyncClient;
import com.oracle.bmc.vnmonitoring.VnMonitoringPaginators;
import com.oracle.bmc.vnmonitoring.VnMonitoringWaiters;
import com.oracle.bmc.vnmonitoring.model.PathAnalyzerTest;
import com.oracle.bmc.vnmonitoring.model.PathAnalyzerTestCollection;
import com.oracle.bmc.vnmonitoring.model.WorkRequest;
import com.oracle.bmc.vnmonitoring.model.WorkRequestErrorCollection;
import com.oracle.bmc.vnmonitoring.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.vnmonitoring.model.WorkRequestResultCollection;
import com.oracle.bmc.vnmonitoring.model.WorkRequestSummaryCollection;
import com.oracle.bmc.vnmonitoring.requests.ChangePathAnalyzerTestCompartmentRequest;
import com.oracle.bmc.vnmonitoring.requests.CreatePathAnalyzerTestRequest;
import com.oracle.bmc.vnmonitoring.requests.DeletePathAnalyzerTestRequest;
import com.oracle.bmc.vnmonitoring.requests.GetPathAnalysisRequest;
import com.oracle.bmc.vnmonitoring.requests.GetPathAnalyzerTestRequest;
import com.oracle.bmc.vnmonitoring.requests.GetWorkRequestRequest;
import com.oracle.bmc.vnmonitoring.requests.ListPathAnalyzerTestsRequest;
import com.oracle.bmc.vnmonitoring.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.vnmonitoring.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.vnmonitoring.requests.ListWorkRequestResultsRequest;
import com.oracle.bmc.vnmonitoring.requests.ListWorkRequestsRequest;
import com.oracle.bmc.vnmonitoring.requests.UpdatePathAnalyzerTestRequest;
import com.oracle.bmc.vnmonitoring.responses.ChangePathAnalyzerTestCompartmentResponse;
import com.oracle.bmc.vnmonitoring.responses.CreatePathAnalyzerTestResponse;
import com.oracle.bmc.vnmonitoring.responses.DeletePathAnalyzerTestResponse;
import com.oracle.bmc.vnmonitoring.responses.GetPathAnalysisResponse;
import com.oracle.bmc.vnmonitoring.responses.GetPathAnalyzerTestResponse;
import com.oracle.bmc.vnmonitoring.responses.GetWorkRequestResponse;
import com.oracle.bmc.vnmonitoring.responses.ListPathAnalyzerTestsResponse;
import com.oracle.bmc.vnmonitoring.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.vnmonitoring.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.vnmonitoring.responses.ListWorkRequestResultsResponse;
import com.oracle.bmc.vnmonitoring.responses.ListWorkRequestsResponse;
import com.oracle.bmc.vnmonitoring.responses.UpdatePathAnalyzerTestResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VnMonitoringClient
extends BaseSyncClient
implements VnMonitoring {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VNMONITORING").serviceEndpointPrefix("").serviceEndpointTemplate("https://vnca-api.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VnMonitoringAsyncClient.class);
    private final VnMonitoringWaiters waiters;
    private final VnMonitoringPaginators paginators;

    private VnMonitoringClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("VnMonitoring-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new VnMonitoringWaiters(executorService, this);
        this.paginators = new VnMonitoringPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangePathAnalyzerTestCompartmentResponse changePathAnalyzerTestCompartment(ChangePathAnalyzerTestCompartmentRequest request) {
        Validate.notBlank((String)request.getPathAnalyzerTestId(), (String)"pathAnalyzerTestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePathAnalyzerTestCompartmentDetails(), "changePathAnalyzerTestCompartmentDetails is required");
        return (ChangePathAnalyzerTestCompartmentResponse)this.clientCall(request, ChangePathAnalyzerTestCompartmentResponse::builder).logger(LOG, "changePathAnalyzerTestCompartment").serviceDetails("VnMonitoring", "ChangePathAnalyzerTestCompartment", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/PathAnalyzerTest/ChangePathAnalyzerTestCompartment").method(Method.POST).requestBuilder(ChangePathAnalyzerTestCompartmentRequest::builder).basePath("/20160918").appendPathParam("pathAnalyzerTests").appendPathParam(request.getPathAnalyzerTestId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ChangePathAnalyzerTestCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangePathAnalyzerTestCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePathAnalyzerTestResponse createPathAnalyzerTest(CreatePathAnalyzerTestRequest request) {
        Objects.requireNonNull(request.getCreatePathAnalyzerTestDetails(), "createPathAnalyzerTestDetails is required");
        return (CreatePathAnalyzerTestResponse)this.clientCall(request, CreatePathAnalyzerTestResponse::builder).logger(LOG, "createPathAnalyzerTest").serviceDetails("VnMonitoring", "CreatePathAnalyzerTest", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/PathAnalyzerTest/CreatePathAnalyzerTest").method(Method.POST).requestBuilder(CreatePathAnalyzerTestRequest::builder).basePath("/20160918").appendPathParam("pathAnalyzerTests").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PathAnalyzerTest.class, CreatePathAnalyzerTestResponse.Builder::pathAnalyzerTest).handleResponseHeaderString("etag", CreatePathAnalyzerTestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePathAnalyzerTestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePathAnalyzerTestResponse deletePathAnalyzerTest(DeletePathAnalyzerTestRequest request) {
        Validate.notBlank((String)request.getPathAnalyzerTestId(), (String)"pathAnalyzerTestId must not be blank", (Object[])new Object[0]);
        return (DeletePathAnalyzerTestResponse)this.clientCall(request, DeletePathAnalyzerTestResponse::builder).logger(LOG, "deletePathAnalyzerTest").serviceDetails("VnMonitoring", "DeletePathAnalyzerTest", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/PathAnalyzerTest/DeletePathAnalyzerTest").method(Method.DELETE).requestBuilder(DeletePathAnalyzerTestRequest::builder).basePath("/20160918").appendPathParam("pathAnalyzerTests").appendPathParam(request.getPathAnalyzerTestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePathAnalyzerTestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPathAnalysisResponse getPathAnalysis(GetPathAnalysisRequest request) {
        Objects.requireNonNull(request.getGetPathAnalysisDetails(), "getPathAnalysisDetails is required");
        return (GetPathAnalysisResponse)this.clientCall(request, GetPathAnalysisResponse::builder).logger(LOG, "getPathAnalysis").serviceDetails("VnMonitoring", "GetPathAnalysis", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/PathAnalysisWorkRequestResult/GetPathAnalysis").method(Method.POST).requestBuilder(GetPathAnalysisRequest::builder).basePath("/20160918").appendPathParam("pathAnalysis").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("cache-control", request.getCacheControl()).hasBody().handleResponseHeaderString("opc-request-id", GetPathAnalysisResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", GetPathAnalysisResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetPathAnalyzerTestResponse getPathAnalyzerTest(GetPathAnalyzerTestRequest request) {
        Validate.notBlank((String)request.getPathAnalyzerTestId(), (String)"pathAnalyzerTestId must not be blank", (Object[])new Object[0]);
        return (GetPathAnalyzerTestResponse)this.clientCall(request, GetPathAnalyzerTestResponse::builder).logger(LOG, "getPathAnalyzerTest").serviceDetails("VnMonitoring", "GetPathAnalyzerTest", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/PathAnalyzerTest/GetPathAnalyzerTest").method(Method.GET).requestBuilder(GetPathAnalyzerTestRequest::builder).basePath("/20160918").appendPathParam("pathAnalyzerTests").appendPathParam(request.getPathAnalyzerTestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PathAnalyzerTest.class, GetPathAnalyzerTestResponse.Builder::pathAnalyzerTest).handleResponseHeaderString("etag", GetPathAnalyzerTestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPathAnalyzerTestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("VnMonitoring", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20160918").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListPathAnalyzerTestsResponse listPathAnalyzerTests(ListPathAnalyzerTestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPathAnalyzerTestsResponse)this.clientCall(request, ListPathAnalyzerTestsResponse::builder).logger(LOG, "listPathAnalyzerTests").serviceDetails("VnMonitoring", "ListPathAnalyzerTests", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/PathAnalyzerTestCollection/ListPathAnalyzerTests").method(Method.GET).requestBuilder(ListPathAnalyzerTestsRequest::builder).basePath("/20160918").appendPathParam("pathAnalyzerTests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PathAnalyzerTestCollection.class, ListPathAnalyzerTestsResponse.Builder::pathAnalyzerTestCollection).handleResponseHeaderString("opc-request-id", ListPathAnalyzerTestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPathAnalyzerTestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("VnMonitoring", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20160918").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("VnMonitoring", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20160918").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestResultsResponse listWorkRequestResults(ListWorkRequestResultsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestResultsResponse)this.clientCall(request, ListWorkRequestResultsResponse::builder).logger(LOG, "listWorkRequestResults").serviceDetails("VnMonitoring", "ListWorkRequestResults", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/WorkRequestResult/ListWorkRequestResults").method(Method.GET).requestBuilder(ListWorkRequestResultsRequest::builder).basePath("/20160918").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("results").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("resultType", (BmcEnum)request.getResultType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestResultCollection.class, ListWorkRequestResultsResponse.Builder::workRequestResultCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("VnMonitoring", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20160918").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdatePathAnalyzerTestResponse updatePathAnalyzerTest(UpdatePathAnalyzerTestRequest request) {
        Validate.notBlank((String)request.getPathAnalyzerTestId(), (String)"pathAnalyzerTestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePathAnalyzerTestDetails(), "updatePathAnalyzerTestDetails is required");
        return (UpdatePathAnalyzerTestResponse)this.clientCall(request, UpdatePathAnalyzerTestResponse::builder).logger(LOG, "updatePathAnalyzerTest").serviceDetails("VnMonitoring", "UpdatePathAnalyzerTest", "https://docs.oracle.com/iaas/api/#/en/NetMonitor/20160918/PathAnalyzerTest/UpdatePathAnalyzerTest").method(Method.PUT).requestBuilder(UpdatePathAnalyzerTestRequest::builder).basePath("/20160918").appendPathParam("pathAnalyzerTests").appendPathParam(request.getPathAnalyzerTestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(PathAnalyzerTest.class, UpdatePathAnalyzerTestResponse.Builder::pathAnalyzerTest).handleResponseHeaderString("etag", UpdatePathAnalyzerTestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePathAnalyzerTestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public VnMonitoringWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public VnMonitoringPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public VnMonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VnMonitoringClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VnMonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VnMonitoringClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VnMonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VnMonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VnMonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VnMonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VnMonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VnMonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VnMonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VnMonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VnMonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VnMonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VnMonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VnMonitoringClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VnMonitoringClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public VnMonitoringClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VnMonitoringClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

