/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.usageapi.model.CreateQueryDetails;
import java.util.Objects;

public class CreateQueryRequest
extends BmcRequest<CreateQueryDetails> {
    private CreateQueryDetails createQueryDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public CreateQueryDetails getCreateQueryDetails() {
        return this.createQueryDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateQueryDetails getBody$() {
        return this.createQueryDetails;
    }

    public Builder toBuilder() {
        return new Builder().createQueryDetails(this.createQueryDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createQueryDetails=").append(String.valueOf((Object)this.createQueryDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateQueryRequest)) {
            return false;
        }
        CreateQueryRequest other = (CreateQueryRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createQueryDetails, (Object)other.createQueryDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createQueryDetails == null ? 43 : this.createQueryDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateQueryRequest, CreateQueryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateQueryDetails createQueryDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder createQueryDetails(CreateQueryDetails createQueryDetails) {
            this.createQueryDetails = createQueryDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateQueryRequest o) {
            this.createQueryDetails(o.getCreateQueryDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateQueryRequest build() {
            CreateQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateQueryDetails body) {
            this.createQueryDetails(body);
            return this;
        }

        public CreateQueryRequest buildWithoutInvocationCallback() {
            CreateQueryRequest request = new CreateQueryRequest();
            request.createQueryDetails = this.createQueryDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

