/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.usageapi.model.ResultLocation;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateScheduleDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="outputFileFormat")
    private final OutputFileFormat outputFileFormat;
    @JsonProperty(value="resultLocation")
    private final ResultLocation resultLocation;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"description", "outputFileFormat", "resultLocation", "freeformTags", "definedTags"})
    public UpdateScheduleDetails(String description, OutputFileFormat outputFileFormat, ResultLocation resultLocation, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.description = description;
        this.outputFileFormat = outputFileFormat;
        this.resultLocation = resultLocation;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public OutputFileFormat getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public ResultLocation getResultLocation() {
        return this.resultLocation;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateScheduleDetails(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", outputFileFormat=").append(String.valueOf((Object)this.outputFileFormat));
        sb.append(", resultLocation=").append(String.valueOf((Object)this.resultLocation));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateScheduleDetails)) {
            return false;
        }
        UpdateScheduleDetails other = (UpdateScheduleDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals((Object)this.outputFileFormat, (Object)other.outputFileFormat) && Objects.equals((Object)this.resultLocation, (Object)other.resultLocation) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.outputFileFormat == null ? 43 : this.outputFileFormat.hashCode());
        result = result * 59 + (this.resultLocation == null ? 43 : this.resultLocation.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OutputFileFormat implements BmcEnum
    {
        Csv("CSV"),
        Pdf("PDF");

        private final String value;
        private static Map<String, OutputFileFormat> map;

        private OutputFileFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OutputFileFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid OutputFileFormat: " + key);
        }

        static {
            map = new HashMap<String, OutputFileFormat>();
            for (OutputFileFormat v : OutputFileFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="outputFileFormat")
        private OutputFileFormat outputFileFormat;
        @JsonProperty(value="resultLocation")
        private ResultLocation resultLocation;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder outputFileFormat(OutputFileFormat outputFileFormat) {
            this.outputFileFormat = outputFileFormat;
            this.__explicitlySet__.add("outputFileFormat");
            return this;
        }

        public Builder resultLocation(ResultLocation resultLocation) {
            this.resultLocation = resultLocation;
            this.__explicitlySet__.add("resultLocation");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateScheduleDetails build() {
            UpdateScheduleDetails model = new UpdateScheduleDetails(this.description, this.outputFileFormat, this.resultLocation, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateScheduleDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("outputFileFormat")) {
                this.outputFileFormat(model.getOutputFileFormat());
            }
            if (model.wasPropertyExplicitlySet("resultLocation")) {
                this.resultLocation(model.getResultLocation());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

