/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.usageapi.model.Tag;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SavedCustomTable
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="rowGroupBy")
    private final List<String> rowGroupBy;
    @JsonProperty(value="columnGroupBy")
    private final List<String> columnGroupBy;
    @JsonProperty(value="groupByTag")
    private final List<Tag> groupByTag;
    @JsonProperty(value="compartmentDepth")
    private final BigDecimal compartmentDepth;
    @JsonProperty(value="version")
    private final BigDecimal version;

    @Deprecated
    @ConstructorProperties(value={"displayName", "rowGroupBy", "columnGroupBy", "groupByTag", "compartmentDepth", "version"})
    public SavedCustomTable(String displayName, List<String> rowGroupBy, List<String> columnGroupBy, List<Tag> groupByTag, BigDecimal compartmentDepth, BigDecimal version) {
        this.displayName = displayName;
        this.rowGroupBy = rowGroupBy;
        this.columnGroupBy = columnGroupBy;
        this.groupByTag = groupByTag;
        this.compartmentDepth = compartmentDepth;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getRowGroupBy() {
        return this.rowGroupBy;
    }

    public List<String> getColumnGroupBy() {
        return this.columnGroupBy;
    }

    public List<Tag> getGroupByTag() {
        return this.groupByTag;
    }

    public BigDecimal getCompartmentDepth() {
        return this.compartmentDepth;
    }

    public BigDecimal getVersion() {
        return this.version;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SavedCustomTable(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", rowGroupBy=").append(String.valueOf(this.rowGroupBy));
        sb.append(", columnGroupBy=").append(String.valueOf(this.columnGroupBy));
        sb.append(", groupByTag=").append(String.valueOf(this.groupByTag));
        sb.append(", compartmentDepth=").append(String.valueOf(this.compartmentDepth));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SavedCustomTable)) {
            return false;
        }
        SavedCustomTable other = (SavedCustomTable)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.rowGroupBy, other.rowGroupBy) && Objects.equals(this.columnGroupBy, other.columnGroupBy) && Objects.equals(this.groupByTag, other.groupByTag) && Objects.equals(this.compartmentDepth, other.compartmentDepth) && Objects.equals(this.version, other.version) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.rowGroupBy == null ? 43 : this.rowGroupBy.hashCode());
        result = result * 59 + (this.columnGroupBy == null ? 43 : this.columnGroupBy.hashCode());
        result = result * 59 + (this.groupByTag == null ? 43 : this.groupByTag.hashCode());
        result = result * 59 + (this.compartmentDepth == null ? 43 : this.compartmentDepth.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="rowGroupBy")
        private List<String> rowGroupBy;
        @JsonProperty(value="columnGroupBy")
        private List<String> columnGroupBy;
        @JsonProperty(value="groupByTag")
        private List<Tag> groupByTag;
        @JsonProperty(value="compartmentDepth")
        private BigDecimal compartmentDepth;
        @JsonProperty(value="version")
        private BigDecimal version;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder rowGroupBy(List<String> rowGroupBy) {
            this.rowGroupBy = rowGroupBy;
            this.__explicitlySet__.add("rowGroupBy");
            return this;
        }

        public Builder columnGroupBy(List<String> columnGroupBy) {
            this.columnGroupBy = columnGroupBy;
            this.__explicitlySet__.add("columnGroupBy");
            return this;
        }

        public Builder groupByTag(List<Tag> groupByTag) {
            this.groupByTag = groupByTag;
            this.__explicitlySet__.add("groupByTag");
            return this;
        }

        public Builder compartmentDepth(BigDecimal compartmentDepth) {
            this.compartmentDepth = compartmentDepth;
            this.__explicitlySet__.add("compartmentDepth");
            return this;
        }

        public Builder version(BigDecimal version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public SavedCustomTable build() {
            SavedCustomTable model = new SavedCustomTable(this.displayName, this.rowGroupBy, this.columnGroupBy, this.groupByTag, this.compartmentDepth, this.version);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SavedCustomTable model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("rowGroupBy")) {
                this.rowGroupBy(model.getRowGroupBy());
            }
            if (model.wasPropertyExplicitlySet("columnGroupBy")) {
                this.columnGroupBy(model.getColumnGroupBy());
            }
            if (model.wasPropertyExplicitlySet("groupByTag")) {
                this.groupByTag(model.getGroupByTag());
            }
            if (model.wasPropertyExplicitlySet("compartmentDepth")) {
                this.compartmentDepth(model.getCompartmentDepth());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            return this;
        }
    }
}

