/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProductSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="productNumber")
    private final String productNumber;
    @JsonProperty(value="productName")
    private final String productName;
    @JsonProperty(value="usageAmount")
    private final Double usageAmount;
    @JsonProperty(value="earnedRewards")
    private final Float earnedRewards;
    @JsonProperty(value="isEligibleToEarnRewards")
    private final Boolean isEligibleToEarnRewards;

    @Deprecated
    @ConstructorProperties(value={"productNumber", "productName", "usageAmount", "earnedRewards", "isEligibleToEarnRewards"})
    public ProductSummary(String productNumber, String productName, Double usageAmount, Float earnedRewards, Boolean isEligibleToEarnRewards) {
        this.productNumber = productNumber;
        this.productName = productName;
        this.usageAmount = usageAmount;
        this.earnedRewards = earnedRewards;
        this.isEligibleToEarnRewards = isEligibleToEarnRewards;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getProductNumber() {
        return this.productNumber;
    }

    public String getProductName() {
        return this.productName;
    }

    public Double getUsageAmount() {
        return this.usageAmount;
    }

    public Float getEarnedRewards() {
        return this.earnedRewards;
    }

    public Boolean getIsEligibleToEarnRewards() {
        return this.isEligibleToEarnRewards;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProductSummary(");
        sb.append("super=").append(super.toString());
        sb.append("productNumber=").append(String.valueOf(this.productNumber));
        sb.append(", productName=").append(String.valueOf(this.productName));
        sb.append(", usageAmount=").append(String.valueOf(this.usageAmount));
        sb.append(", earnedRewards=").append(String.valueOf(this.earnedRewards));
        sb.append(", isEligibleToEarnRewards=").append(String.valueOf(this.isEligibleToEarnRewards));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductSummary)) {
            return false;
        }
        ProductSummary other = (ProductSummary)((Object)o);
        return Objects.equals(this.productNumber, other.productNumber) && Objects.equals(this.productName, other.productName) && Objects.equals(this.usageAmount, other.usageAmount) && Objects.equals(this.earnedRewards, other.earnedRewards) && Objects.equals(this.isEligibleToEarnRewards, other.isEligibleToEarnRewards) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.productNumber == null ? 43 : this.productNumber.hashCode());
        result = result * 59 + (this.productName == null ? 43 : this.productName.hashCode());
        result = result * 59 + (this.usageAmount == null ? 43 : this.usageAmount.hashCode());
        result = result * 59 + (this.earnedRewards == null ? 43 : this.earnedRewards.hashCode());
        result = result * 59 + (this.isEligibleToEarnRewards == null ? 43 : this.isEligibleToEarnRewards.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="productNumber")
        private String productNumber;
        @JsonProperty(value="productName")
        private String productName;
        @JsonProperty(value="usageAmount")
        private Double usageAmount;
        @JsonProperty(value="earnedRewards")
        private Float earnedRewards;
        @JsonProperty(value="isEligibleToEarnRewards")
        private Boolean isEligibleToEarnRewards;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder productNumber(String productNumber) {
            this.productNumber = productNumber;
            this.__explicitlySet__.add("productNumber");
            return this;
        }

        public Builder productName(String productName) {
            this.productName = productName;
            this.__explicitlySet__.add("productName");
            return this;
        }

        public Builder usageAmount(Double usageAmount) {
            this.usageAmount = usageAmount;
            this.__explicitlySet__.add("usageAmount");
            return this;
        }

        public Builder earnedRewards(Float earnedRewards) {
            this.earnedRewards = earnedRewards;
            this.__explicitlySet__.add("earnedRewards");
            return this;
        }

        public Builder isEligibleToEarnRewards(Boolean isEligibleToEarnRewards) {
            this.isEligibleToEarnRewards = isEligibleToEarnRewards;
            this.__explicitlySet__.add("isEligibleToEarnRewards");
            return this;
        }

        public ProductSummary build() {
            ProductSummary model = new ProductSummary(this.productNumber, this.productName, this.usageAmount, this.earnedRewards, this.isEligibleToEarnRewards);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProductSummary model) {
            if (model.wasPropertyExplicitlySet("productNumber")) {
                this.productNumber(model.getProductNumber());
            }
            if (model.wasPropertyExplicitlySet("productName")) {
                this.productName(model.getProductName());
            }
            if (model.wasPropertyExplicitlySet("usageAmount")) {
                this.usageAmount(model.getUsageAmount());
            }
            if (model.wasPropertyExplicitlySet("earnedRewards")) {
                this.earnedRewards(model.getEarnedRewards());
            }
            if (model.wasPropertyExplicitlySet("isEligibleToEarnRewards")) {
                this.isEligibleToEarnRewards(model.getIsEligibleToEarnRewards());
            }
            return this;
        }
    }
}

