/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.tenantmanagercontrolplane.model.SortOrder;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionMapping;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSubscriptionMappingsRequest
extends BmcRequest<Void> {
    private String subscriptionId;
    private String subscriptionMappingId;
    private String compartmentId;
    private SubscriptionMapping.LifecycleState lifecycleState;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;
    private SortBy sortBy;

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getSubscriptionMappingId() {
        return this.subscriptionMappingId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public SubscriptionMapping.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new Builder().subscriptionId(this.subscriptionId).subscriptionMappingId(this.subscriptionMappingId).compartmentId(this.compartmentId).lifecycleState(this.lifecycleState).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).sortOrder(this.sortOrder).sortBy(this.sortBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",subscriptionMappingId=").append(String.valueOf(this.subscriptionMappingId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSubscriptionMappingsRequest)) {
            return false;
        }
        ListSubscriptionMappingsRequest other = (ListSubscriptionMappingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.subscriptionMappingId, other.subscriptionMappingId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.subscriptionMappingId == null ? 43 : this.subscriptionMappingId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSubscriptionMappingsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String subscriptionId = null;
        private String subscriptionMappingId = null;
        private String compartmentId = null;
        private SubscriptionMapping.LifecycleState lifecycleState = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder subscriptionMappingId(String subscriptionMappingId) {
            this.subscriptionMappingId = subscriptionMappingId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder lifecycleState(SubscriptionMapping.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSubscriptionMappingsRequest o) {
            this.subscriptionId(o.getSubscriptionId());
            this.subscriptionMappingId(o.getSubscriptionMappingId());
            this.compartmentId(o.getCompartmentId());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSubscriptionMappingsRequest build() {
            ListSubscriptionMappingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSubscriptionMappingsRequest buildWithoutInvocationCallback() {
            ListSubscriptionMappingsRequest request = new ListSubscriptionMappingsRequest();
            request.subscriptionId = this.subscriptionId;
            request.subscriptionMappingId = this.subscriptionMappingId;
            request.compartmentId = this.compartmentId;
            request.lifecycleState = this.lifecycleState;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

