/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionLifecycleState;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SubscriptionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="classicSubscriptionId")
    private final String classicSubscriptionId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="isClassicSubscription")
    private final Boolean isClassicSubscription;
    @JsonProperty(value="paymentModel")
    private final String paymentModel;
    @JsonProperty(value="regionAssignment")
    private final String regionAssignment;
    @JsonProperty(value="lifecycleState")
    private final SubscriptionLifecycleState lifecycleState;
    @JsonProperty(value="startDate")
    private final Date startDate;
    @JsonProperty(value="endDate")
    private final Date endDate;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"id", "classicSubscriptionId", "compartmentId", "serviceName", "isClassicSubscription", "paymentModel", "regionAssignment", "lifecycleState", "startDate", "endDate", "timeUpdated", "timeCreated"})
    public SubscriptionSummary(String id, String classicSubscriptionId, String compartmentId, String serviceName, Boolean isClassicSubscription, String paymentModel, String regionAssignment, SubscriptionLifecycleState lifecycleState, Date startDate, Date endDate, Date timeUpdated, Date timeCreated) {
        this.id = id;
        this.classicSubscriptionId = classicSubscriptionId;
        this.compartmentId = compartmentId;
        this.serviceName = serviceName;
        this.isClassicSubscription = isClassicSubscription;
        this.paymentModel = paymentModel;
        this.regionAssignment = regionAssignment;
        this.lifecycleState = lifecycleState;
        this.startDate = startDate;
        this.endDate = endDate;
        this.timeUpdated = timeUpdated;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getClassicSubscriptionId() {
        return this.classicSubscriptionId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Boolean getIsClassicSubscription() {
        return this.isClassicSubscription;
    }

    public String getPaymentModel() {
        return this.paymentModel;
    }

    public String getRegionAssignment() {
        return this.regionAssignment;
    }

    public SubscriptionLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", classicSubscriptionId=").append(String.valueOf(this.classicSubscriptionId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", isClassicSubscription=").append(String.valueOf(this.isClassicSubscription));
        sb.append(", paymentModel=").append(String.valueOf(this.paymentModel));
        sb.append(", regionAssignment=").append(String.valueOf(this.regionAssignment));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", startDate=").append(String.valueOf(this.startDate));
        sb.append(", endDate=").append(String.valueOf(this.endDate));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionSummary)) {
            return false;
        }
        SubscriptionSummary other = (SubscriptionSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.classicSubscriptionId, other.classicSubscriptionId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.isClassicSubscription, other.isClassicSubscription) && Objects.equals(this.paymentModel, other.paymentModel) && Objects.equals(this.regionAssignment, other.regionAssignment) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.startDate, other.startDate) && Objects.equals(this.endDate, other.endDate) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.classicSubscriptionId == null ? 43 : this.classicSubscriptionId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.isClassicSubscription == null ? 43 : this.isClassicSubscription.hashCode());
        result = result * 59 + (this.paymentModel == null ? 43 : this.paymentModel.hashCode());
        result = result * 59 + (this.regionAssignment == null ? 43 : this.regionAssignment.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.startDate == null ? 43 : this.startDate.hashCode());
        result = result * 59 + (this.endDate == null ? 43 : this.endDate.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="classicSubscriptionId")
        private String classicSubscriptionId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="isClassicSubscription")
        private Boolean isClassicSubscription;
        @JsonProperty(value="paymentModel")
        private String paymentModel;
        @JsonProperty(value="regionAssignment")
        private String regionAssignment;
        @JsonProperty(value="lifecycleState")
        private SubscriptionLifecycleState lifecycleState;
        @JsonProperty(value="startDate")
        private Date startDate;
        @JsonProperty(value="endDate")
        private Date endDate;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder classicSubscriptionId(String classicSubscriptionId) {
            this.classicSubscriptionId = classicSubscriptionId;
            this.__explicitlySet__.add("classicSubscriptionId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder isClassicSubscription(Boolean isClassicSubscription) {
            this.isClassicSubscription = isClassicSubscription;
            this.__explicitlySet__.add("isClassicSubscription");
            return this;
        }

        public Builder paymentModel(String paymentModel) {
            this.paymentModel = paymentModel;
            this.__explicitlySet__.add("paymentModel");
            return this;
        }

        public Builder regionAssignment(String regionAssignment) {
            this.regionAssignment = regionAssignment;
            this.__explicitlySet__.add("regionAssignment");
            return this;
        }

        public Builder lifecycleState(SubscriptionLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            this.__explicitlySet__.add("startDate");
            return this;
        }

        public Builder endDate(Date endDate) {
            this.endDate = endDate;
            this.__explicitlySet__.add("endDate");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public SubscriptionSummary build() {
            SubscriptionSummary model = new SubscriptionSummary(this.id, this.classicSubscriptionId, this.compartmentId, this.serviceName, this.isClassicSubscription, this.paymentModel, this.regionAssignment, this.lifecycleState, this.startDate, this.endDate, this.timeUpdated, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubscriptionSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("classicSubscriptionId")) {
                this.classicSubscriptionId(model.getClassicSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("isClassicSubscription")) {
                this.isClassicSubscription(model.getIsClassicSubscription());
            }
            if (model.wasPropertyExplicitlySet("paymentModel")) {
                this.paymentModel(model.getPaymentModel());
            }
            if (model.wasPropertyExplicitlySet("regionAssignment")) {
                this.regionAssignment(model.getRegionAssignment());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("startDate")) {
                this.startDate(model.getStartDate());
            }
            if (model.wasPropertyExplicitlySet("endDate")) {
                this.endDate(model.getEndDate());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

