/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionMapping;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SubscriptionMappingSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="subscriptionId")
    private final String subscriptionId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="isExplicitlyAssigned")
    private final Boolean isExplicitlyAssigned;
    @JsonProperty(value="lifecycleState")
    private final SubscriptionMapping.LifecycleState lifecycleState;
    @JsonProperty(value="timeTerminated")
    private final Date timeTerminated;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "subscriptionId", "compartmentId", "isExplicitlyAssigned", "lifecycleState", "timeTerminated", "timeCreated", "timeUpdated"})
    public SubscriptionMappingSummary(String id, String subscriptionId, String compartmentId, Boolean isExplicitlyAssigned, SubscriptionMapping.LifecycleState lifecycleState, Date timeTerminated, Date timeCreated, Date timeUpdated) {
        this.id = id;
        this.subscriptionId = subscriptionId;
        this.compartmentId = compartmentId;
        this.isExplicitlyAssigned = isExplicitlyAssigned;
        this.lifecycleState = lifecycleState;
        this.timeTerminated = timeTerminated;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsExplicitlyAssigned() {
        return this.isExplicitlyAssigned;
    }

    public SubscriptionMapping.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeTerminated() {
        return this.timeTerminated;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionMappingSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", isExplicitlyAssigned=").append(String.valueOf(this.isExplicitlyAssigned));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeTerminated=").append(String.valueOf(this.timeTerminated));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionMappingSummary)) {
            return false;
        }
        SubscriptionMappingSummary other = (SubscriptionMappingSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.isExplicitlyAssigned, other.isExplicitlyAssigned) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeTerminated, other.timeTerminated) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.isExplicitlyAssigned == null ? 43 : this.isExplicitlyAssigned.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeTerminated == null ? 43 : this.timeTerminated.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="subscriptionId")
        private String subscriptionId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="isExplicitlyAssigned")
        private Boolean isExplicitlyAssigned;
        @JsonProperty(value="lifecycleState")
        private SubscriptionMapping.LifecycleState lifecycleState;
        @JsonProperty(value="timeTerminated")
        private Date timeTerminated;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.__explicitlySet__.add("subscriptionId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder isExplicitlyAssigned(Boolean isExplicitlyAssigned) {
            this.isExplicitlyAssigned = isExplicitlyAssigned;
            this.__explicitlySet__.add("isExplicitlyAssigned");
            return this;
        }

        public Builder lifecycleState(SubscriptionMapping.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeTerminated(Date timeTerminated) {
            this.timeTerminated = timeTerminated;
            this.__explicitlySet__.add("timeTerminated");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public SubscriptionMappingSummary build() {
            SubscriptionMappingSummary model = new SubscriptionMappingSummary(this.id, this.subscriptionId, this.compartmentId, this.isExplicitlyAssigned, this.lifecycleState, this.timeTerminated, this.timeCreated, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubscriptionMappingSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("subscriptionId")) {
                this.subscriptionId(model.getSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("isExplicitlyAssigned")) {
                this.isExplicitlyAssigned(model.getIsExplicitlyAssigned());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeTerminated")) {
                this.timeTerminated(model.getTimeTerminated());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

