/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Promotion
extends ExplicitlySetBmcModel {
    @JsonProperty(value="duration")
    private final Integer duration;
    @JsonProperty(value="durationUnit")
    private final String durationUnit;
    @JsonProperty(value="amount")
    private final Float amount;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="isIntentToPay")
    private final Boolean isIntentToPay;
    @JsonProperty(value="currencyUnit")
    private final String currencyUnit;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeExpired")
    private final Date timeExpired;

    @Deprecated
    @ConstructorProperties(value={"duration", "durationUnit", "amount", "status", "isIntentToPay", "currencyUnit", "timeStarted", "timeExpired"})
    public Promotion(Integer duration, String durationUnit, Float amount, Status status, Boolean isIntentToPay, String currencyUnit, Date timeStarted, Date timeExpired) {
        this.duration = duration;
        this.durationUnit = durationUnit;
        this.amount = amount;
        this.status = status;
        this.isIntentToPay = isIntentToPay;
        this.currencyUnit = currencyUnit;
        this.timeStarted = timeStarted;
        this.timeExpired = timeExpired;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getDurationUnit() {
        return this.durationUnit;
    }

    public Float getAmount() {
        return this.amount;
    }

    public Status getStatus() {
        return this.status;
    }

    public Boolean getIsIntentToPay() {
        return this.isIntentToPay;
    }

    public String getCurrencyUnit() {
        return this.currencyUnit;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeExpired() {
        return this.timeExpired;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Promotion(");
        sb.append("super=").append(super.toString());
        sb.append("duration=").append(String.valueOf(this.duration));
        sb.append(", durationUnit=").append(String.valueOf(this.durationUnit));
        sb.append(", amount=").append(String.valueOf(this.amount));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", isIntentToPay=").append(String.valueOf(this.isIntentToPay));
        sb.append(", currencyUnit=").append(String.valueOf(this.currencyUnit));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeExpired=").append(String.valueOf(this.timeExpired));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Promotion)) {
            return false;
        }
        Promotion other = (Promotion)((Object)o);
        return Objects.equals(this.duration, other.duration) && Objects.equals(this.durationUnit, other.durationUnit) && Objects.equals(this.amount, other.amount) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.isIntentToPay, other.isIntentToPay) && Objects.equals(this.currencyUnit, other.currencyUnit) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeExpired, other.timeExpired) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.duration == null ? 43 : this.duration.hashCode());
        result = result * 59 + (this.durationUnit == null ? 43 : this.durationUnit.hashCode());
        result = result * 59 + (this.amount == null ? 43 : this.amount.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.isIntentToPay == null ? 43 : this.isIntentToPay.hashCode());
        result = result * 59 + (this.currencyUnit == null ? 43 : this.currencyUnit.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeExpired == null ? 43 : this.timeExpired.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Initialized("INITIALIZED"),
        Active("ACTIVE"),
        Expired("EXPIRED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="duration")
        private Integer duration;
        @JsonProperty(value="durationUnit")
        private String durationUnit;
        @JsonProperty(value="amount")
        private Float amount;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="isIntentToPay")
        private Boolean isIntentToPay;
        @JsonProperty(value="currencyUnit")
        private String currencyUnit;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeExpired")
        private Date timeExpired;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.__explicitlySet__.add("duration");
            return this;
        }

        public Builder durationUnit(String durationUnit) {
            this.durationUnit = durationUnit;
            this.__explicitlySet__.add("durationUnit");
            return this;
        }

        public Builder amount(Float amount) {
            this.amount = amount;
            this.__explicitlySet__.add("amount");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder isIntentToPay(Boolean isIntentToPay) {
            this.isIntentToPay = isIntentToPay;
            this.__explicitlySet__.add("isIntentToPay");
            return this;
        }

        public Builder currencyUnit(String currencyUnit) {
            this.currencyUnit = currencyUnit;
            this.__explicitlySet__.add("currencyUnit");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeExpired(Date timeExpired) {
            this.timeExpired = timeExpired;
            this.__explicitlySet__.add("timeExpired");
            return this;
        }

        public Promotion build() {
            Promotion model = new Promotion(this.duration, this.durationUnit, this.amount, this.status, this.isIntentToPay, this.currencyUnit, this.timeStarted, this.timeExpired);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Promotion model) {
            if (model.wasPropertyExplicitlySet("duration")) {
                this.duration(model.getDuration());
            }
            if (model.wasPropertyExplicitlySet("durationUnit")) {
                this.durationUnit(model.getDurationUnit());
            }
            if (model.wasPropertyExplicitlySet("amount")) {
                this.amount(model.getAmount());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("isIntentToPay")) {
                this.isIntentToPay(model.getIsIntentToPay());
            }
            if (model.wasPropertyExplicitlySet("currencyUnit")) {
                this.currencyUnit(model.getCurrencyUnit());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeExpired")) {
                this.timeExpired(model.getTimeExpired());
            }
            return this;
        }
    }
}

