/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionInfo;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Order
extends ExplicitlySetBmcModel {
    @JsonProperty(value="orderNumber")
    private final String orderNumber;
    @JsonProperty(value="dataCenterRegion")
    private final String dataCenterRegion;
    @JsonProperty(value="adminEmail")
    private final String adminEmail;
    @JsonProperty(value="orderState")
    private final String orderState;
    @JsonProperty(value="subscriptions")
    private final List<SubscriptionInfo> subscriptions;

    @Deprecated
    @ConstructorProperties(value={"orderNumber", "dataCenterRegion", "adminEmail", "orderState", "subscriptions"})
    public Order(String orderNumber, String dataCenterRegion, String adminEmail, String orderState, List<SubscriptionInfo> subscriptions) {
        this.orderNumber = orderNumber;
        this.dataCenterRegion = dataCenterRegion;
        this.adminEmail = adminEmail;
        this.orderState = orderState;
        this.subscriptions = subscriptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getDataCenterRegion() {
        return this.dataCenterRegion;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public String getOrderState() {
        return this.orderState;
    }

    public List<SubscriptionInfo> getSubscriptions() {
        return this.subscriptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Order(");
        sb.append("super=").append(super.toString());
        sb.append("orderNumber=").append(String.valueOf(this.orderNumber));
        sb.append(", dataCenterRegion=").append(String.valueOf(this.dataCenterRegion));
        sb.append(", adminEmail=").append(String.valueOf(this.adminEmail));
        sb.append(", orderState=").append(String.valueOf(this.orderState));
        sb.append(", subscriptions=").append(String.valueOf(this.subscriptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)((Object)o);
        return Objects.equals(this.orderNumber, other.orderNumber) && Objects.equals(this.dataCenterRegion, other.dataCenterRegion) && Objects.equals(this.adminEmail, other.adminEmail) && Objects.equals(this.orderState, other.orderState) && Objects.equals(this.subscriptions, other.subscriptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.orderNumber == null ? 43 : this.orderNumber.hashCode());
        result = result * 59 + (this.dataCenterRegion == null ? 43 : this.dataCenterRegion.hashCode());
        result = result * 59 + (this.adminEmail == null ? 43 : this.adminEmail.hashCode());
        result = result * 59 + (this.orderState == null ? 43 : this.orderState.hashCode());
        result = result * 59 + (this.subscriptions == null ? 43 : this.subscriptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="orderNumber")
        private String orderNumber;
        @JsonProperty(value="dataCenterRegion")
        private String dataCenterRegion;
        @JsonProperty(value="adminEmail")
        private String adminEmail;
        @JsonProperty(value="orderState")
        private String orderState;
        @JsonProperty(value="subscriptions")
        private List<SubscriptionInfo> subscriptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            this.__explicitlySet__.add("orderNumber");
            return this;
        }

        public Builder dataCenterRegion(String dataCenterRegion) {
            this.dataCenterRegion = dataCenterRegion;
            this.__explicitlySet__.add("dataCenterRegion");
            return this;
        }

        public Builder adminEmail(String adminEmail) {
            this.adminEmail = adminEmail;
            this.__explicitlySet__.add("adminEmail");
            return this;
        }

        public Builder orderState(String orderState) {
            this.orderState = orderState;
            this.__explicitlySet__.add("orderState");
            return this;
        }

        public Builder subscriptions(List<SubscriptionInfo> subscriptions) {
            this.subscriptions = subscriptions;
            this.__explicitlySet__.add("subscriptions");
            return this;
        }

        public Order build() {
            Order model = new Order(this.orderNumber, this.dataCenterRegion, this.adminEmail, this.orderState, this.subscriptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Order model) {
            if (model.wasPropertyExplicitlySet("orderNumber")) {
                this.orderNumber(model.getOrderNumber());
            }
            if (model.wasPropertyExplicitlySet("dataCenterRegion")) {
                this.dataCenterRegion(model.getDataCenterRegion());
            }
            if (model.wasPropertyExplicitlySet("adminEmail")) {
                this.adminEmail(model.getAdminEmail());
            }
            if (model.wasPropertyExplicitlySet("orderState")) {
                this.orderState(model.getOrderState());
            }
            if (model.wasPropertyExplicitlySet("subscriptions")) {
                this.subscriptions(model.getSubscriptions());
            }
            return this;
        }
    }
}

