/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.SenderInvitation;
import com.oracle.bmc.tenantmanagercontrolplane.model.SenderInvitationSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSenderInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSenderInvitationsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SenderInvitationPaginators {
    private final SenderInvitation client;

    public SenderInvitationPaginators(SenderInvitation client) {
        this.client = client;
    }

    public Iterable<ListSenderInvitationsResponse> listSenderInvitationsResponseIterator(final ListSenderInvitationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSenderInvitationsRequest.Builder>(){

            @Override
            public ListSenderInvitationsRequest.Builder get() {
                return ListSenderInvitationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSenderInvitationsResponse, String>(){

            @Override
            public String apply(ListSenderInvitationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSenderInvitationsRequest.Builder>, ListSenderInvitationsRequest>(){

            @Override
            public ListSenderInvitationsRequest apply(RequestBuilderAndToken<ListSenderInvitationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSenderInvitationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSenderInvitationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSenderInvitationsRequest, ListSenderInvitationsResponse>(){

            @Override
            public ListSenderInvitationsResponse apply(ListSenderInvitationsRequest request) {
                return SenderInvitationPaginators.this.client.listSenderInvitations(request);
            }
        });
    }

    public Iterable<SenderInvitationSummary> listSenderInvitationsRecordIterator(final ListSenderInvitationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSenderInvitationsRequest.Builder>(){

            @Override
            public ListSenderInvitationsRequest.Builder get() {
                return ListSenderInvitationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSenderInvitationsResponse, String>(){

            @Override
            public String apply(ListSenderInvitationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSenderInvitationsRequest.Builder>, ListSenderInvitationsRequest>(){

            @Override
            public ListSenderInvitationsRequest apply(RequestBuilderAndToken<ListSenderInvitationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSenderInvitationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSenderInvitationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSenderInvitationsRequest, ListSenderInvitationsResponse>(){

            @Override
            public ListSenderInvitationsResponse apply(ListSenderInvitationsRequest request) {
                return SenderInvitationPaginators.this.client.listSenderInvitations(request);
            }
        }, (Function)new Function<ListSenderInvitationsResponse, List<SenderInvitationSummary>>(){

            @Override
            public List<SenderInvitationSummary> apply(ListSenderInvitationsResponse response) {
                return response.getSenderInvitationCollection().getItems();
            }
        });
    }
}

