/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.Link;
import com.oracle.bmc.tenantmanagercontrolplane.model.LinkSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListLinksRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListLinksResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class LinkPaginators {
    private final Link client;

    public LinkPaginators(Link client) {
        this.client = client;
    }

    public Iterable<ListLinksResponse> listLinksResponseIterator(final ListLinksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLinksRequest.Builder>(){

            @Override
            public ListLinksRequest.Builder get() {
                return ListLinksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLinksResponse, String>(){

            @Override
            public String apply(ListLinksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLinksRequest.Builder>, ListLinksRequest>(){

            @Override
            public ListLinksRequest apply(RequestBuilderAndToken<ListLinksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLinksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLinksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLinksRequest, ListLinksResponse>(){

            @Override
            public ListLinksResponse apply(ListLinksRequest request) {
                return LinkPaginators.this.client.listLinks(request);
            }
        });
    }

    public Iterable<LinkSummary> listLinksRecordIterator(final ListLinksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLinksRequest.Builder>(){

            @Override
            public ListLinksRequest.Builder get() {
                return ListLinksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLinksResponse, String>(){

            @Override
            public String apply(ListLinksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLinksRequest.Builder>, ListLinksRequest>(){

            @Override
            public ListLinksRequest apply(RequestBuilderAndToken<ListLinksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLinksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLinksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLinksRequest, ListLinksResponse>(){

            @Override
            public ListLinksResponse apply(ListLinksRequest request) {
                return LinkPaginators.this.client.listLinks(request);
            }
        }, (Function)new Function<ListLinksResponse, List<LinkSummary>>(){

            @Override
            public List<LinkSummary> apply(ListLinksResponse response) {
                return response.getLinkCollection().getItems();
            }
        });
    }
}

