/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.DomainGovernance;
import com.oracle.bmc.tenantmanagercontrolplane.model.DomainGovernanceSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListDomainGovernancesRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListDomainGovernancesResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DomainGovernancePaginators {
    private final DomainGovernance client;

    public DomainGovernancePaginators(DomainGovernance client) {
        this.client = client;
    }

    public Iterable<ListDomainGovernancesResponse> listDomainGovernancesResponseIterator(final ListDomainGovernancesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDomainGovernancesRequest.Builder>(){

            @Override
            public ListDomainGovernancesRequest.Builder get() {
                return ListDomainGovernancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDomainGovernancesResponse, String>(){

            @Override
            public String apply(ListDomainGovernancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDomainGovernancesRequest.Builder>, ListDomainGovernancesRequest>(){

            @Override
            public ListDomainGovernancesRequest apply(RequestBuilderAndToken<ListDomainGovernancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDomainGovernancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDomainGovernancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDomainGovernancesRequest, ListDomainGovernancesResponse>(){

            @Override
            public ListDomainGovernancesResponse apply(ListDomainGovernancesRequest request) {
                return DomainGovernancePaginators.this.client.listDomainGovernances(request);
            }
        });
    }

    public Iterable<DomainGovernanceSummary> listDomainGovernancesRecordIterator(final ListDomainGovernancesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDomainGovernancesRequest.Builder>(){

            @Override
            public ListDomainGovernancesRequest.Builder get() {
                return ListDomainGovernancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDomainGovernancesResponse, String>(){

            @Override
            public String apply(ListDomainGovernancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDomainGovernancesRequest.Builder>, ListDomainGovernancesRequest>(){

            @Override
            public ListDomainGovernancesRequest apply(RequestBuilderAndToken<ListDomainGovernancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDomainGovernancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDomainGovernancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDomainGovernancesRequest, ListDomainGovernancesResponse>(){

            @Override
            public ListDomainGovernancesResponse apply(ListDomainGovernancesRequest request) {
                return DomainGovernancePaginators.this.client.listDomainGovernances(request);
            }
        }, (Function)new Function<ListDomainGovernancesResponse, List<DomainGovernanceSummary>>(){

            @Override
            public List<DomainGovernanceSummary> apply(ListDomainGovernancesResponse response) {
                return response.getDomainGovernanceCollection().getItems();
            }
        });
    }
}

