/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.responses;

import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceCollection;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SearchMonitoredResourcesResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private Integer opcTotalItems;
    private MonitoredResourceCollection monitoredResourceCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public MonitoredResourceCollection getMonitoredResourceCollection() {
        return this.monitoredResourceCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "opcTotalItems", "monitoredResourceCollection"})
    private SearchMonitoredResourcesResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, Integer opcTotalItems, MonitoredResourceCollection monitoredResourceCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.opcTotalItems = opcTotalItems;
        this.monitoredResourceCollection = monitoredResourceCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcTotalItems=").append(String.valueOf(this.opcTotalItems));
        sb.append(",monitoredResourceCollection=").append(String.valueOf((Object)this.monitoredResourceCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchMonitoredResourcesResponse)) {
            return false;
        }
        SearchMonitoredResourcesResponse other = (SearchMonitoredResourcesResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcTotalItems, other.opcTotalItems) && Objects.equals((Object)this.monitoredResourceCollection, (Object)other.monitoredResourceCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcTotalItems == null ? 43 : this.opcTotalItems.hashCode());
        result = result * 59 + (this.monitoredResourceCollection == null ? 43 : this.monitoredResourceCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<SearchMonitoredResourcesResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private Integer opcTotalItems;
        private MonitoredResourceCollection monitoredResourceCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder monitoredResourceCollection(MonitoredResourceCollection monitoredResourceCollection) {
            this.monitoredResourceCollection = monitoredResourceCollection;
            return this;
        }

        public Builder copy(SearchMonitoredResourcesResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.opcTotalItems(o.getOpcTotalItems());
            this.monitoredResourceCollection(o.getMonitoredResourceCollection());
            return this;
        }

        public SearchMonitoredResourcesResponse build() {
            return new SearchMonitoredResourcesResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.opcTotalItems, this.monitoredResourceCollection);
        }
    }
}

