/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.stackmonitoring.model.SearchMonitoredResourcesDetails;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SearchMonitoredResourcesRequest
extends BmcRequest<SearchMonitoredResourcesDetails> {
    private SearchMonitoredResourcesDetails searchMonitoredResourcesDetails;
    private Integer limit;
    private String page;
    private List<String> fields;
    private List<String> excludeFields;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public SearchMonitoredResourcesDetails getSearchMonitoredResourcesDetails() {
        return this.searchMonitoredResourcesDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getExcludeFields() {
        return this.excludeFields;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public SearchMonitoredResourcesDetails getBody$() {
        return this.searchMonitoredResourcesDetails;
    }

    public Builder toBuilder() {
        return new Builder().searchMonitoredResourcesDetails(this.searchMonitoredResourcesDetails).limit(this.limit).page(this.page).fields(this.fields).excludeFields(this.excludeFields).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",searchMonitoredResourcesDetails=").append(String.valueOf((Object)this.searchMonitoredResourcesDetails));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",excludeFields=").append(String.valueOf(this.excludeFields));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchMonitoredResourcesRequest)) {
            return false;
        }
        SearchMonitoredResourcesRequest other = (SearchMonitoredResourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.searchMonitoredResourcesDetails, (Object)other.searchMonitoredResourcesDetails) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.fields, other.fields) && Objects.equals(this.excludeFields, other.excludeFields) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.searchMonitoredResourcesDetails == null ? 43 : this.searchMonitoredResourcesDetails.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.excludeFields == null ? 43 : this.excludeFields.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SearchMonitoredResourcesRequest, SearchMonitoredResourcesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private SearchMonitoredResourcesDetails searchMonitoredResourcesDetails = null;
        private Integer limit = null;
        private String page = null;
        private List<String> fields = null;
        private List<String> excludeFields = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder searchMonitoredResourcesDetails(SearchMonitoredResourcesDetails searchMonitoredResourcesDetails) {
            this.searchMonitoredResourcesDetails = searchMonitoredResourcesDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder excludeFields(List<String> excludeFields) {
            this.excludeFields = excludeFields;
            return this;
        }

        public Builder excludeFields(String singularValue) {
            return this.excludeFields(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SearchMonitoredResourcesRequest o) {
            this.searchMonitoredResourcesDetails(o.getSearchMonitoredResourcesDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.fields(o.getFields());
            this.excludeFields(o.getExcludeFields());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SearchMonitoredResourcesRequest build() {
            SearchMonitoredResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SearchMonitoredResourcesDetails body) {
            this.searchMonitoredResourcesDetails(body);
            return this;
        }

        public SearchMonitoredResourcesRequest buildWithoutInvocationCallback() {
            SearchMonitoredResourcesRequest request = new SearchMonitoredResourcesRequest();
            request.searchMonitoredResourcesDetails = this.searchMonitoredResourcesDetails;
            request.limit = this.limit;
            request.page = this.page;
            request.fields = this.fields;
            request.excludeFields = this.excludeFields;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

