/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.stackmonitoring.model.SearchMonitoredResourceMembersDetails;
import com.oracle.bmc.stackmonitoring.model.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SearchMonitoredResourceMembersRequest
extends BmcRequest<SearchMonitoredResourceMembersDetails> {
    private String monitoredResourceId;
    private SearchMonitoredResourceMembersDetails searchMonitoredResourceMembersDetails;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String page;
    private Integer limit;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    public String getMonitoredResourceId() {
        return this.monitoredResourceId;
    }

    public SearchMonitoredResourceMembersDetails getSearchMonitoredResourceMembersDetails() {
        return this.searchMonitoredResourceMembersDetails;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public SearchMonitoredResourceMembersDetails getBody$() {
        return this.searchMonitoredResourceMembersDetails;
    }

    public Builder toBuilder() {
        return new Builder().monitoredResourceId(this.monitoredResourceId).searchMonitoredResourceMembersDetails(this.searchMonitoredResourceMembersDetails).sortBy(this.sortBy).sortOrder(this.sortOrder).page(this.page).limit(this.limit).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",monitoredResourceId=").append(String.valueOf(this.monitoredResourceId));
        sb.append(",searchMonitoredResourceMembersDetails=").append(String.valueOf((Object)this.searchMonitoredResourceMembersDetails));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchMonitoredResourceMembersRequest)) {
            return false;
        }
        SearchMonitoredResourceMembersRequest other = (SearchMonitoredResourceMembersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.monitoredResourceId, other.monitoredResourceId) && Objects.equals((Object)this.searchMonitoredResourceMembersDetails, (Object)other.searchMonitoredResourceMembersDetails) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.monitoredResourceId == null ? 43 : this.monitoredResourceId.hashCode());
        result = result * 59 + (this.searchMonitoredResourceMembersDetails == null ? 43 : this.searchMonitoredResourceMembersDetails.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SearchMonitoredResourceMembersRequest, SearchMonitoredResourceMembersDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String monitoredResourceId = null;
        private SearchMonitoredResourceMembersDetails searchMonitoredResourceMembersDetails = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String page = null;
        private Integer limit = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder monitoredResourceId(String monitoredResourceId) {
            this.monitoredResourceId = monitoredResourceId;
            return this;
        }

        public Builder searchMonitoredResourceMembersDetails(SearchMonitoredResourceMembersDetails searchMonitoredResourceMembersDetails) {
            this.searchMonitoredResourceMembersDetails = searchMonitoredResourceMembersDetails;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SearchMonitoredResourceMembersRequest o) {
            this.monitoredResourceId(o.getMonitoredResourceId());
            this.searchMonitoredResourceMembersDetails(o.getSearchMonitoredResourceMembersDetails());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SearchMonitoredResourceMembersRequest build() {
            SearchMonitoredResourceMembersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SearchMonitoredResourceMembersDetails body) {
            this.searchMonitoredResourceMembersDetails(body);
            return this;
        }

        public SearchMonitoredResourceMembersRequest buildWithoutInvocationCallback() {
            SearchMonitoredResourceMembersRequest request = new SearchMonitoredResourceMembersRequest();
            request.monitoredResourceId = this.monitoredResourceId;
            request.searchMonitoredResourceMembersDetails = this.searchMonitoredResourceMembersDetails;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        ResourceName("resourceName"),
        ResourceType("resourceType"),
        SourceResourceType("sourceResourceType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

