/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMonitoredResourceRequest
extends BmcRequest<Void> {
    private String monitoredResourceId;
    private String opcRequestId;

    public String getMonitoredResourceId() {
        return this.monitoredResourceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().monitoredResourceId(this.monitoredResourceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",monitoredResourceId=").append(String.valueOf(this.monitoredResourceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMonitoredResourceRequest)) {
            return false;
        }
        GetMonitoredResourceRequest other = (GetMonitoredResourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.monitoredResourceId, other.monitoredResourceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.monitoredResourceId == null ? 43 : this.monitoredResourceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMonitoredResourceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String monitoredResourceId = null;
        private String opcRequestId = null;

        public Builder monitoredResourceId(String monitoredResourceId) {
            this.monitoredResourceId = monitoredResourceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMonitoredResourceRequest o) {
            this.monitoredResourceId(o.getMonitoredResourceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMonitoredResourceRequest build() {
            GetMonitoredResourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMonitoredResourceRequest buildWithoutInvocationCallback() {
            GetMonitoredResourceRequest request = new GetMonitoredResourceRequest();
            request.monitoredResourceId = this.monitoredResourceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

