/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteMonitoredResourceRequest
extends BmcRequest<Void> {
    private String monitoredResourceId;
    private String ifMatch;
    private String opcRequestId;
    private Boolean isDeleteMembers;

    public String getMonitoredResourceId() {
        return this.monitoredResourceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsDeleteMembers() {
        return this.isDeleteMembers;
    }

    public Builder toBuilder() {
        return new Builder().monitoredResourceId(this.monitoredResourceId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).isDeleteMembers(this.isDeleteMembers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",monitoredResourceId=").append(String.valueOf(this.monitoredResourceId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isDeleteMembers=").append(String.valueOf(this.isDeleteMembers));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteMonitoredResourceRequest)) {
            return false;
        }
        DeleteMonitoredResourceRequest other = (DeleteMonitoredResourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.monitoredResourceId, other.monitoredResourceId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isDeleteMembers, other.isDeleteMembers);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.monitoredResourceId == null ? 43 : this.monitoredResourceId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isDeleteMembers == null ? 43 : this.isDeleteMembers.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteMonitoredResourceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String monitoredResourceId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private Boolean isDeleteMembers = null;

        public Builder monitoredResourceId(String monitoredResourceId) {
            this.monitoredResourceId = monitoredResourceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isDeleteMembers(Boolean isDeleteMembers) {
            this.isDeleteMembers = isDeleteMembers;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteMonitoredResourceRequest o) {
            this.monitoredResourceId(o.getMonitoredResourceId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.isDeleteMembers(o.getIsDeleteMembers());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteMonitoredResourceRequest build() {
            DeleteMonitoredResourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteMonitoredResourceRequest buildWithoutInvocationCallback() {
            DeleteMonitoredResourceRequest request = new DeleteMonitoredResourceRequest();
            request.monitoredResourceId = this.monitoredResourceId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.isDeleteMembers = this.isDeleteMembers;
            return request;
        }
    }
}

