/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.stackmonitoring.model.ConnectionDetails;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceAliasCredential;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceCredential;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceProperty;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateMonitoredResourceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="resourceTimeZone")
    private final String resourceTimeZone;
    @JsonProperty(value="properties")
    private final List<MonitoredResourceProperty> properties;
    @JsonProperty(value="databaseConnectionDetails")
    private final ConnectionDetails databaseConnectionDetails;
    @JsonProperty(value="credentials")
    private final MonitoredResourceCredential credentials;
    @JsonProperty(value="aliases")
    private final MonitoredResourceAliasCredential aliases;

    @Deprecated
    @ConstructorProperties(value={"displayName", "hostName", "resourceTimeZone", "properties", "databaseConnectionDetails", "credentials", "aliases"})
    public UpdateMonitoredResourceDetails(String displayName, String hostName, String resourceTimeZone, List<MonitoredResourceProperty> properties, ConnectionDetails databaseConnectionDetails, MonitoredResourceCredential credentials, MonitoredResourceAliasCredential aliases) {
        this.displayName = displayName;
        this.hostName = hostName;
        this.resourceTimeZone = resourceTimeZone;
        this.properties = properties;
        this.databaseConnectionDetails = databaseConnectionDetails;
        this.credentials = credentials;
        this.aliases = aliases;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getResourceTimeZone() {
        return this.resourceTimeZone;
    }

    public List<MonitoredResourceProperty> getProperties() {
        return this.properties;
    }

    public ConnectionDetails getDatabaseConnectionDetails() {
        return this.databaseConnectionDetails;
    }

    public MonitoredResourceCredential getCredentials() {
        return this.credentials;
    }

    public MonitoredResourceAliasCredential getAliases() {
        return this.aliases;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateMonitoredResourceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", hostName=").append(String.valueOf(this.hostName));
        sb.append(", resourceTimeZone=").append(String.valueOf(this.resourceTimeZone));
        sb.append(", properties=").append(String.valueOf(this.properties));
        sb.append(", databaseConnectionDetails=").append(String.valueOf((Object)this.databaseConnectionDetails));
        sb.append(", credentials=").append(String.valueOf((Object)this.credentials));
        sb.append(", aliases=").append(String.valueOf((Object)this.aliases));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMonitoredResourceDetails)) {
            return false;
        }
        UpdateMonitoredResourceDetails other = (UpdateMonitoredResourceDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.resourceTimeZone, other.resourceTimeZone) && Objects.equals(this.properties, other.properties) && Objects.equals((Object)this.databaseConnectionDetails, (Object)other.databaseConnectionDetails) && Objects.equals((Object)this.credentials, (Object)other.credentials) && Objects.equals((Object)this.aliases, (Object)other.aliases) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.resourceTimeZone == null ? 43 : this.resourceTimeZone.hashCode());
        result = result * 59 + (this.properties == null ? 43 : this.properties.hashCode());
        result = result * 59 + (this.databaseConnectionDetails == null ? 43 : this.databaseConnectionDetails.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + (this.aliases == null ? 43 : this.aliases.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="resourceTimeZone")
        private String resourceTimeZone;
        @JsonProperty(value="properties")
        private List<MonitoredResourceProperty> properties;
        @JsonProperty(value="databaseConnectionDetails")
        private ConnectionDetails databaseConnectionDetails;
        @JsonProperty(value="credentials")
        private MonitoredResourceCredential credentials;
        @JsonProperty(value="aliases")
        private MonitoredResourceAliasCredential aliases;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder resourceTimeZone(String resourceTimeZone) {
            this.resourceTimeZone = resourceTimeZone;
            this.__explicitlySet__.add("resourceTimeZone");
            return this;
        }

        public Builder properties(List<MonitoredResourceProperty> properties) {
            this.properties = properties;
            this.__explicitlySet__.add("properties");
            return this;
        }

        public Builder databaseConnectionDetails(ConnectionDetails databaseConnectionDetails) {
            this.databaseConnectionDetails = databaseConnectionDetails;
            this.__explicitlySet__.add("databaseConnectionDetails");
            return this;
        }

        public Builder credentials(MonitoredResourceCredential credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public Builder aliases(MonitoredResourceAliasCredential aliases) {
            this.aliases = aliases;
            this.__explicitlySet__.add("aliases");
            return this;
        }

        public UpdateMonitoredResourceDetails build() {
            UpdateMonitoredResourceDetails model = new UpdateMonitoredResourceDetails(this.displayName, this.hostName, this.resourceTimeZone, this.properties, this.databaseConnectionDetails, this.credentials, this.aliases);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateMonitoredResourceDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("resourceTimeZone")) {
                this.resourceTimeZone(model.getResourceTimeZone());
            }
            if (model.wasPropertyExplicitlySet("properties")) {
                this.properties(model.getProperties());
            }
            if (model.wasPropertyExplicitlySet("databaseConnectionDetails")) {
                this.databaseConnectionDetails(model.getDatabaseConnectionDetails());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            if (model.wasPropertyExplicitlySet("aliases")) {
                this.aliases(model.getAliases());
            }
            return this;
        }
    }
}

