/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.stackmonitoring.model.SortOrder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SearchMonitoredResourceAssociationsDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="sourceResourceId")
    private final String sourceResourceId;
    @JsonProperty(value="sourceResourceName")
    private final String sourceResourceName;
    @JsonProperty(value="sourceResourceType")
    private final String sourceResourceType;
    @JsonProperty(value="destinationResourceId")
    private final String destinationResourceId;
    @JsonProperty(value="destinationResourceName")
    private final String destinationResourceName;
    @JsonProperty(value="destinationResourceType")
    private final String destinationResourceType;
    @JsonProperty(value="associationType")
    private final String associationType;
    @JsonProperty(value="sortBy")
    private final SortBy sortBy;
    @JsonProperty(value="sortOrder")
    private final SortOrder sortOrder;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "sourceResourceId", "sourceResourceName", "sourceResourceType", "destinationResourceId", "destinationResourceName", "destinationResourceType", "associationType", "sortBy", "sortOrder"})
    public SearchMonitoredResourceAssociationsDetails(String compartmentId, String sourceResourceId, String sourceResourceName, String sourceResourceType, String destinationResourceId, String destinationResourceName, String destinationResourceType, String associationType, SortBy sortBy, SortOrder sortOrder) {
        this.compartmentId = compartmentId;
        this.sourceResourceId = sourceResourceId;
        this.sourceResourceName = sourceResourceName;
        this.sourceResourceType = sourceResourceType;
        this.destinationResourceId = destinationResourceId;
        this.destinationResourceName = destinationResourceName;
        this.destinationResourceType = destinationResourceType;
        this.associationType = associationType;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSourceResourceId() {
        return this.sourceResourceId;
    }

    public String getSourceResourceName() {
        return this.sourceResourceName;
    }

    public String getSourceResourceType() {
        return this.sourceResourceType;
    }

    public String getDestinationResourceId() {
        return this.destinationResourceId;
    }

    public String getDestinationResourceName() {
        return this.destinationResourceName;
    }

    public String getDestinationResourceType() {
        return this.destinationResourceType;
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SearchMonitoredResourceAssociationsDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", sourceResourceId=").append(String.valueOf(this.sourceResourceId));
        sb.append(", sourceResourceName=").append(String.valueOf(this.sourceResourceName));
        sb.append(", sourceResourceType=").append(String.valueOf(this.sourceResourceType));
        sb.append(", destinationResourceId=").append(String.valueOf(this.destinationResourceId));
        sb.append(", destinationResourceName=").append(String.valueOf(this.destinationResourceName));
        sb.append(", destinationResourceType=").append(String.valueOf(this.destinationResourceType));
        sb.append(", associationType=").append(String.valueOf(this.associationType));
        sb.append(", sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(", sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchMonitoredResourceAssociationsDetails)) {
            return false;
        }
        SearchMonitoredResourceAssociationsDetails other = (SearchMonitoredResourceAssociationsDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.sourceResourceId, other.sourceResourceId) && Objects.equals(this.sourceResourceName, other.sourceResourceName) && Objects.equals(this.sourceResourceType, other.sourceResourceType) && Objects.equals(this.destinationResourceId, other.destinationResourceId) && Objects.equals(this.destinationResourceName, other.destinationResourceName) && Objects.equals(this.destinationResourceType, other.destinationResourceType) && Objects.equals(this.associationType, other.associationType) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.sourceResourceId == null ? 43 : this.sourceResourceId.hashCode());
        result = result * 59 + (this.sourceResourceName == null ? 43 : this.sourceResourceName.hashCode());
        result = result * 59 + (this.sourceResourceType == null ? 43 : this.sourceResourceType.hashCode());
        result = result * 59 + (this.destinationResourceId == null ? 43 : this.destinationResourceId.hashCode());
        result = result * 59 + (this.destinationResourceName == null ? 43 : this.destinationResourceName.hashCode());
        result = result * 59 + (this.destinationResourceType == null ? 43 : this.destinationResourceType.hashCode());
        result = result * 59 + (this.associationType == null ? 43 : this.associationType.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("TIME_CREATED"),
        AssocType("ASSOC_TYPE");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="sourceResourceId")
        private String sourceResourceId;
        @JsonProperty(value="sourceResourceName")
        private String sourceResourceName;
        @JsonProperty(value="sourceResourceType")
        private String sourceResourceType;
        @JsonProperty(value="destinationResourceId")
        private String destinationResourceId;
        @JsonProperty(value="destinationResourceName")
        private String destinationResourceName;
        @JsonProperty(value="destinationResourceType")
        private String destinationResourceType;
        @JsonProperty(value="associationType")
        private String associationType;
        @JsonProperty(value="sortBy")
        private SortBy sortBy;
        @JsonProperty(value="sortOrder")
        private SortOrder sortOrder;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder sourceResourceId(String sourceResourceId) {
            this.sourceResourceId = sourceResourceId;
            this.__explicitlySet__.add("sourceResourceId");
            return this;
        }

        public Builder sourceResourceName(String sourceResourceName) {
            this.sourceResourceName = sourceResourceName;
            this.__explicitlySet__.add("sourceResourceName");
            return this;
        }

        public Builder sourceResourceType(String sourceResourceType) {
            this.sourceResourceType = sourceResourceType;
            this.__explicitlySet__.add("sourceResourceType");
            return this;
        }

        public Builder destinationResourceId(String destinationResourceId) {
            this.destinationResourceId = destinationResourceId;
            this.__explicitlySet__.add("destinationResourceId");
            return this;
        }

        public Builder destinationResourceName(String destinationResourceName) {
            this.destinationResourceName = destinationResourceName;
            this.__explicitlySet__.add("destinationResourceName");
            return this;
        }

        public Builder destinationResourceType(String destinationResourceType) {
            this.destinationResourceType = destinationResourceType;
            this.__explicitlySet__.add("destinationResourceType");
            return this;
        }

        public Builder associationType(String associationType) {
            this.associationType = associationType;
            this.__explicitlySet__.add("associationType");
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            this.__explicitlySet__.add("sortBy");
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            this.__explicitlySet__.add("sortOrder");
            return this;
        }

        public SearchMonitoredResourceAssociationsDetails build() {
            SearchMonitoredResourceAssociationsDetails model = new SearchMonitoredResourceAssociationsDetails(this.compartmentId, this.sourceResourceId, this.sourceResourceName, this.sourceResourceType, this.destinationResourceId, this.destinationResourceName, this.destinationResourceType, this.associationType, this.sortBy, this.sortOrder);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SearchMonitoredResourceAssociationsDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("sourceResourceId")) {
                this.sourceResourceId(model.getSourceResourceId());
            }
            if (model.wasPropertyExplicitlySet("sourceResourceName")) {
                this.sourceResourceName(model.getSourceResourceName());
            }
            if (model.wasPropertyExplicitlySet("sourceResourceType")) {
                this.sourceResourceType(model.getSourceResourceType());
            }
            if (model.wasPropertyExplicitlySet("destinationResourceId")) {
                this.destinationResourceId(model.getDestinationResourceId());
            }
            if (model.wasPropertyExplicitlySet("destinationResourceName")) {
                this.destinationResourceName(model.getDestinationResourceName());
            }
            if (model.wasPropertyExplicitlySet("destinationResourceType")) {
                this.destinationResourceType(model.getDestinationResourceType());
            }
            if (model.wasPropertyExplicitlySet("associationType")) {
                this.associationType(model.getAssociationType());
            }
            if (model.wasPropertyExplicitlySet("sortBy")) {
                this.sortBy(model.getSortBy());
            }
            if (model.wasPropertyExplicitlySet("sortOrder")) {
                this.sortOrder(model.getSortOrder());
            }
            return this;
        }
    }
}

