/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SearchAssociatedResourcesDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="limitLevel")
    private final Integer limitLevel;
    @JsonProperty(value="associationTypes")
    private final List<String> associationTypes;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "resourceType", "resourceId", "limitLevel", "associationTypes"})
    public SearchAssociatedResourcesDetails(String compartmentId, String resourceType, String resourceId, Integer limitLevel, List<String> associationTypes) {
        this.compartmentId = compartmentId;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.limitLevel = limitLevel;
        this.associationTypes = associationTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Integer getLimitLevel() {
        return this.limitLevel;
    }

    public List<String> getAssociationTypes() {
        return this.associationTypes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SearchAssociatedResourcesDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", limitLevel=").append(String.valueOf(this.limitLevel));
        sb.append(", associationTypes=").append(String.valueOf(this.associationTypes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchAssociatedResourcesDetails)) {
            return false;
        }
        SearchAssociatedResourcesDetails other = (SearchAssociatedResourcesDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.limitLevel, other.limitLevel) && Objects.equals(this.associationTypes, other.associationTypes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.limitLevel == null ? 43 : this.limitLevel.hashCode());
        result = result * 59 + (this.associationTypes == null ? 43 : this.associationTypes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="limitLevel")
        private Integer limitLevel;
        @JsonProperty(value="associationTypes")
        private List<String> associationTypes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder limitLevel(Integer limitLevel) {
            this.limitLevel = limitLevel;
            this.__explicitlySet__.add("limitLevel");
            return this;
        }

        public Builder associationTypes(List<String> associationTypes) {
            this.associationTypes = associationTypes;
            this.__explicitlySet__.add("associationTypes");
            return this;
        }

        public SearchAssociatedResourcesDetails build() {
            SearchAssociatedResourcesDetails model = new SearchAssociatedResourcesDetails(this.compartmentId, this.resourceType, this.resourceId, this.limitLevel, this.associationTypes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SearchAssociatedResourcesDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("limitLevel")) {
                this.limitLevel(model.getLimitLevel());
            }
            if (model.wasPropertyExplicitlySet("associationTypes")) {
                this.associationTypes(model.getAssociationTypes());
            }
            return this;
        }
    }
}

