/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.stackmonitoring.model.EncryptedCredentials;
import com.oracle.bmc.stackmonitoring.model.PlainTextCredentials;
import com.oracle.bmc.stackmonitoring.model.PreExistingCredentials;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="credentialType", defaultImpl=MonitoredResourceCredential.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PreExistingCredentials.class, name="EXISTING"), @JsonSubTypes.Type(value=EncryptedCredentials.class, name="ENCRYPTED"), @JsonSubTypes.Type(value=PlainTextCredentials.class, name="PLAINTEXT")})
@JsonFilter(value="explicitlySetFilter")
public class MonitoredResourceCredential
extends ExplicitlySetBmcModel {
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"source", "name", "type", "description"})
    protected MonitoredResourceCredential(String source, String name, String type, String description) {
        this.source = source;
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonitoredResourceCredential(");
        sb.append("super=").append(super.toString());
        sb.append("source=").append(String.valueOf(this.source));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitoredResourceCredential)) {
            return false;
        }
        MonitoredResourceCredential other = (MonitoredResourceCredential)((Object)o);
        return Objects.equals(this.source, other.source) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CredentialType implements BmcEnum
    {
        Existing("EXISTING"),
        Plaintext("PLAINTEXT"),
        Encrypted("ENCRYPTED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CredentialType> map;

        private CredentialType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CredentialType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CredentialType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CredentialType.class);
            map = new HashMap<String, CredentialType>();
            for (CredentialType v : CredentialType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

