/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.stackmonitoring.model.AssociationResourceDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MonitoredResourceAssociationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="associationType")
    private final String associationType;
    @JsonProperty(value="sourceResourceId")
    private final String sourceResourceId;
    @JsonProperty(value="destinationResourceId")
    private final String destinationResourceId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="sourceResourceDetails")
    private final AssociationResourceDetails sourceResourceDetails;
    @JsonProperty(value="destinationResourceDetails")
    private final AssociationResourceDetails destinationResourceDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"associationType", "sourceResourceId", "destinationResourceId", "timeCreated", "sourceResourceDetails", "destinationResourceDetails", "freeformTags", "definedTags", "systemTags"})
    public MonitoredResourceAssociationSummary(String associationType, String sourceResourceId, String destinationResourceId, Date timeCreated, AssociationResourceDetails sourceResourceDetails, AssociationResourceDetails destinationResourceDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.associationType = associationType;
        this.sourceResourceId = sourceResourceId;
        this.destinationResourceId = destinationResourceId;
        this.timeCreated = timeCreated;
        this.sourceResourceDetails = sourceResourceDetails;
        this.destinationResourceDetails = destinationResourceDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public String getSourceResourceId() {
        return this.sourceResourceId;
    }

    public String getDestinationResourceId() {
        return this.destinationResourceId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public AssociationResourceDetails getSourceResourceDetails() {
        return this.sourceResourceDetails;
    }

    public AssociationResourceDetails getDestinationResourceDetails() {
        return this.destinationResourceDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonitoredResourceAssociationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("associationType=").append(String.valueOf(this.associationType));
        sb.append(", sourceResourceId=").append(String.valueOf(this.sourceResourceId));
        sb.append(", destinationResourceId=").append(String.valueOf(this.destinationResourceId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", sourceResourceDetails=").append(String.valueOf((Object)this.sourceResourceDetails));
        sb.append(", destinationResourceDetails=").append(String.valueOf((Object)this.destinationResourceDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitoredResourceAssociationSummary)) {
            return false;
        }
        MonitoredResourceAssociationSummary other = (MonitoredResourceAssociationSummary)((Object)o);
        return Objects.equals(this.associationType, other.associationType) && Objects.equals(this.sourceResourceId, other.sourceResourceId) && Objects.equals(this.destinationResourceId, other.destinationResourceId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.sourceResourceDetails, (Object)other.sourceResourceDetails) && Objects.equals((Object)this.destinationResourceDetails, (Object)other.destinationResourceDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.associationType == null ? 43 : this.associationType.hashCode());
        result = result * 59 + (this.sourceResourceId == null ? 43 : this.sourceResourceId.hashCode());
        result = result * 59 + (this.destinationResourceId == null ? 43 : this.destinationResourceId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.sourceResourceDetails == null ? 43 : this.sourceResourceDetails.hashCode());
        result = result * 59 + (this.destinationResourceDetails == null ? 43 : this.destinationResourceDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="associationType")
        private String associationType;
        @JsonProperty(value="sourceResourceId")
        private String sourceResourceId;
        @JsonProperty(value="destinationResourceId")
        private String destinationResourceId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="sourceResourceDetails")
        private AssociationResourceDetails sourceResourceDetails;
        @JsonProperty(value="destinationResourceDetails")
        private AssociationResourceDetails destinationResourceDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder associationType(String associationType) {
            this.associationType = associationType;
            this.__explicitlySet__.add("associationType");
            return this;
        }

        public Builder sourceResourceId(String sourceResourceId) {
            this.sourceResourceId = sourceResourceId;
            this.__explicitlySet__.add("sourceResourceId");
            return this;
        }

        public Builder destinationResourceId(String destinationResourceId) {
            this.destinationResourceId = destinationResourceId;
            this.__explicitlySet__.add("destinationResourceId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder sourceResourceDetails(AssociationResourceDetails sourceResourceDetails) {
            this.sourceResourceDetails = sourceResourceDetails;
            this.__explicitlySet__.add("sourceResourceDetails");
            return this;
        }

        public Builder destinationResourceDetails(AssociationResourceDetails destinationResourceDetails) {
            this.destinationResourceDetails = destinationResourceDetails;
            this.__explicitlySet__.add("destinationResourceDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public MonitoredResourceAssociationSummary build() {
            MonitoredResourceAssociationSummary model = new MonitoredResourceAssociationSummary(this.associationType, this.sourceResourceId, this.destinationResourceId, this.timeCreated, this.sourceResourceDetails, this.destinationResourceDetails, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonitoredResourceAssociationSummary model) {
            if (model.wasPropertyExplicitlySet("associationType")) {
                this.associationType(model.getAssociationType());
            }
            if (model.wasPropertyExplicitlySet("sourceResourceId")) {
                this.sourceResourceId(model.getSourceResourceId());
            }
            if (model.wasPropertyExplicitlySet("destinationResourceId")) {
                this.destinationResourceId(model.getDestinationResourceId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("sourceResourceDetails")) {
                this.sourceResourceDetails(model.getSourceResourceDetails());
            }
            if (model.wasPropertyExplicitlySet("destinationResourceDetails")) {
                this.destinationResourceDetails(model.getDestinationResourceDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

