/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.stackmonitoring.model.AssociationResourceDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MonitoredResourceAssociation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="associationType")
    private final String associationType;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="tenantId")
    private final String tenantId;
    @JsonProperty(value="sourceResourceId")
    private final String sourceResourceId;
    @JsonProperty(value="destinationResourceId")
    private final String destinationResourceId;
    @JsonProperty(value="sourceResourceDetails")
    private final AssociationResourceDetails sourceResourceDetails;
    @JsonProperty(value="destinationResourceDetails")
    private final AssociationResourceDetails destinationResourceDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"associationType", "compartmentId", "tenantId", "sourceResourceId", "destinationResourceId", "sourceResourceDetails", "destinationResourceDetails", "timeCreated", "freeformTags", "definedTags", "systemTags"})
    public MonitoredResourceAssociation(String associationType, String compartmentId, String tenantId, String sourceResourceId, String destinationResourceId, AssociationResourceDetails sourceResourceDetails, AssociationResourceDetails destinationResourceDetails, Date timeCreated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.associationType = associationType;
        this.compartmentId = compartmentId;
        this.tenantId = tenantId;
        this.sourceResourceId = sourceResourceId;
        this.destinationResourceId = destinationResourceId;
        this.sourceResourceDetails = sourceResourceDetails;
        this.destinationResourceDetails = destinationResourceDetails;
        this.timeCreated = timeCreated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getSourceResourceId() {
        return this.sourceResourceId;
    }

    public String getDestinationResourceId() {
        return this.destinationResourceId;
    }

    public AssociationResourceDetails getSourceResourceDetails() {
        return this.sourceResourceDetails;
    }

    public AssociationResourceDetails getDestinationResourceDetails() {
        return this.destinationResourceDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonitoredResourceAssociation(");
        sb.append("super=").append(super.toString());
        sb.append("associationType=").append(String.valueOf(this.associationType));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", tenantId=").append(String.valueOf(this.tenantId));
        sb.append(", sourceResourceId=").append(String.valueOf(this.sourceResourceId));
        sb.append(", destinationResourceId=").append(String.valueOf(this.destinationResourceId));
        sb.append(", sourceResourceDetails=").append(String.valueOf((Object)this.sourceResourceDetails));
        sb.append(", destinationResourceDetails=").append(String.valueOf((Object)this.destinationResourceDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitoredResourceAssociation)) {
            return false;
        }
        MonitoredResourceAssociation other = (MonitoredResourceAssociation)((Object)o);
        return Objects.equals(this.associationType, other.associationType) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.sourceResourceId, other.sourceResourceId) && Objects.equals(this.destinationResourceId, other.destinationResourceId) && Objects.equals((Object)this.sourceResourceDetails, (Object)other.sourceResourceDetails) && Objects.equals((Object)this.destinationResourceDetails, (Object)other.destinationResourceDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.associationType == null ? 43 : this.associationType.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.sourceResourceId == null ? 43 : this.sourceResourceId.hashCode());
        result = result * 59 + (this.destinationResourceId == null ? 43 : this.destinationResourceId.hashCode());
        result = result * 59 + (this.sourceResourceDetails == null ? 43 : this.sourceResourceDetails.hashCode());
        result = result * 59 + (this.destinationResourceDetails == null ? 43 : this.destinationResourceDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="associationType")
        private String associationType;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="tenantId")
        private String tenantId;
        @JsonProperty(value="sourceResourceId")
        private String sourceResourceId;
        @JsonProperty(value="destinationResourceId")
        private String destinationResourceId;
        @JsonProperty(value="sourceResourceDetails")
        private AssociationResourceDetails sourceResourceDetails;
        @JsonProperty(value="destinationResourceDetails")
        private AssociationResourceDetails destinationResourceDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder associationType(String associationType) {
            this.associationType = associationType;
            this.__explicitlySet__.add("associationType");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.__explicitlySet__.add("tenantId");
            return this;
        }

        public Builder sourceResourceId(String sourceResourceId) {
            this.sourceResourceId = sourceResourceId;
            this.__explicitlySet__.add("sourceResourceId");
            return this;
        }

        public Builder destinationResourceId(String destinationResourceId) {
            this.destinationResourceId = destinationResourceId;
            this.__explicitlySet__.add("destinationResourceId");
            return this;
        }

        public Builder sourceResourceDetails(AssociationResourceDetails sourceResourceDetails) {
            this.sourceResourceDetails = sourceResourceDetails;
            this.__explicitlySet__.add("sourceResourceDetails");
            return this;
        }

        public Builder destinationResourceDetails(AssociationResourceDetails destinationResourceDetails) {
            this.destinationResourceDetails = destinationResourceDetails;
            this.__explicitlySet__.add("destinationResourceDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public MonitoredResourceAssociation build() {
            MonitoredResourceAssociation model = new MonitoredResourceAssociation(this.associationType, this.compartmentId, this.tenantId, this.sourceResourceId, this.destinationResourceId, this.sourceResourceDetails, this.destinationResourceDetails, this.timeCreated, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonitoredResourceAssociation model) {
            if (model.wasPropertyExplicitlySet("associationType")) {
                this.associationType(model.getAssociationType());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("tenantId")) {
                this.tenantId(model.getTenantId());
            }
            if (model.wasPropertyExplicitlySet("sourceResourceId")) {
                this.sourceResourceId(model.getSourceResourceId());
            }
            if (model.wasPropertyExplicitlySet("destinationResourceId")) {
                this.destinationResourceId(model.getDestinationResourceId());
            }
            if (model.wasPropertyExplicitlySet("sourceResourceDetails")) {
                this.sourceResourceDetails(model.getSourceResourceDetails());
            }
            if (model.wasPropertyExplicitlySet("destinationResourceDetails")) {
                this.destinationResourceDetails(model.getDestinationResourceDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

