/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceAliasSourceCredential;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MonitoredResourceAliasCredential
extends ExplicitlySetBmcModel {
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="credential")
    private final MonitoredResourceAliasSourceCredential credential;

    @Deprecated
    @ConstructorProperties(value={"source", "name", "credential"})
    public MonitoredResourceAliasCredential(String source, String name, MonitoredResourceAliasSourceCredential credential) {
        this.source = source;
        this.name = name;
        this.credential = credential;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public MonitoredResourceAliasSourceCredential getCredential() {
        return this.credential;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonitoredResourceAliasCredential(");
        sb.append("super=").append(super.toString());
        sb.append("source=").append(String.valueOf(this.source));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", credential=").append(String.valueOf((Object)this.credential));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitoredResourceAliasCredential)) {
            return false;
        }
        MonitoredResourceAliasCredential other = (MonitoredResourceAliasCredential)((Object)o);
        return Objects.equals(this.source, other.source) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.credential, (Object)other.credential) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.credential == null ? 43 : this.credential.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="credential")
        private MonitoredResourceAliasSourceCredential credential;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder credential(MonitoredResourceAliasSourceCredential credential) {
            this.credential = credential;
            this.__explicitlySet__.add("credential");
            return this;
        }

        public MonitoredResourceAliasCredential build() {
            MonitoredResourceAliasCredential model = new MonitoredResourceAliasCredential(this.source, this.name, this.credential);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonitoredResourceAliasCredential model) {
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("credential")) {
                this.credential(model.getCredential());
            }
            return this;
        }
    }
}

