/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.stackmonitoring.model.CredentialProperty;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceCredential;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="credentialType")
@JsonFilter(value="explicitlySetFilter")
public final class EncryptedCredentials
extends MonitoredResourceCredential {
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="properties")
    private final List<CredentialProperty> properties;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public EncryptedCredentials(String source, String name, String type, String description, String keyId, List<CredentialProperty> properties) {
        super(source, name, type, description);
        this.keyId = keyId;
        this.properties = properties;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public List<CredentialProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EncryptedCredentials(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", properties=").append(String.valueOf(this.properties));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptedCredentials)) {
            return false;
        }
        EncryptedCredentials other = (EncryptedCredentials)((Object)o);
        return Objects.equals(this.keyId, other.keyId) && Objects.equals(this.properties, other.properties) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.properties == null ? 43 : this.properties.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="properties")
        private List<CredentialProperty> properties;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder properties(List<CredentialProperty> properties) {
            this.properties = properties;
            this.__explicitlySet__.add("properties");
            return this;
        }

        public EncryptedCredentials build() {
            EncryptedCredentials model = new EncryptedCredentials(this.source, this.name, this.type, this.description, this.keyId, this.properties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EncryptedCredentials model) {
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("properties")) {
                this.properties(model.getProperties());
            }
            return this;
        }
    }
}

