/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.stackmonitoring.model.CredentialCollection;
import com.oracle.bmc.stackmonitoring.model.PropertyDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveryDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="agentId")
    private final String agentId;
    @JsonProperty(value="resourceType")
    private final ResourceType resourceType;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="properties")
    private final PropertyDetails properties;
    @JsonProperty(value="credentials")
    private final CredentialCollection credentials;
    @JsonProperty(value="tags")
    private final PropertyDetails tags;

    @Deprecated
    @ConstructorProperties(value={"agentId", "resourceType", "resourceName", "properties", "credentials", "tags"})
    public DiscoveryDetails(String agentId, ResourceType resourceType, String resourceName, PropertyDetails properties, CredentialCollection credentials, PropertyDetails tags) {
        this.agentId = agentId;
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.properties = properties;
        this.credentials = credentials;
        this.tags = tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAgentId() {
        return this.agentId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public PropertyDetails getProperties() {
        return this.properties;
    }

    public CredentialCollection getCredentials() {
        return this.credentials;
    }

    public PropertyDetails getTags() {
        return this.tags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveryDetails(");
        sb.append("super=").append(super.toString());
        sb.append("agentId=").append(String.valueOf(this.agentId));
        sb.append(", resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", properties=").append(String.valueOf((Object)this.properties));
        sb.append(", credentials=").append(String.valueOf((Object)this.credentials));
        sb.append(", tags=").append(String.valueOf((Object)this.tags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveryDetails)) {
            return false;
        }
        DiscoveryDetails other = (DiscoveryDetails)((Object)o);
        return Objects.equals(this.agentId, other.agentId) && Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals((Object)this.properties, (Object)other.properties) && Objects.equals((Object)this.credentials, (Object)other.credentials) && Objects.equals((Object)this.tags, (Object)other.tags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.properties == null ? 43 : this.properties.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + (this.tags == null ? 43 : this.tags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceType implements BmcEnum
    {
        WeblogicDomain("WEBLOGIC_DOMAIN"),
        EbsInstance("EBS_INSTANCE"),
        SqlServer("SQL_SERVER"),
        ApacheTomcat("APACHE_TOMCAT"),
        OracleDatabase("ORACLE_DATABASE"),
        OciOracleDb("OCI_ORACLE_DB"),
        OciOracleCdb("OCI_ORACLE_CDB"),
        OciOraclePdb("OCI_ORACLE_PDB"),
        Host("HOST"),
        OraclePsft("ORACLE_PSFT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceType.class);
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="resourceType")
        private ResourceType resourceType;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="properties")
        private PropertyDetails properties;
        @JsonProperty(value="credentials")
        private CredentialCollection credentials;
        @JsonProperty(value="tags")
        private PropertyDetails tags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder properties(PropertyDetails properties) {
            this.properties = properties;
            this.__explicitlySet__.add("properties");
            return this;
        }

        public Builder credentials(CredentialCollection credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public Builder tags(PropertyDetails tags) {
            this.tags = tags;
            this.__explicitlySet__.add("tags");
            return this;
        }

        public DiscoveryDetails build() {
            DiscoveryDetails model = new DiscoveryDetails(this.agentId, this.resourceType, this.resourceName, this.properties, this.credentials, this.tags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveryDetails model) {
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("properties")) {
                this.properties(model.getProperties());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            if (model.wasPropertyExplicitlySet("tags")) {
                this.tags(model.getTags());
            }
            return this;
        }
    }
}

