/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.stackmonitoring.model.DiscoveryDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDiscoveryJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="discoveryType")
    private final DiscoveryType discoveryType;
    @JsonProperty(value="discoveryClient")
    private final String discoveryClient;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="discoveryDetails")
    private final DiscoveryDetails discoveryDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"discoveryType", "discoveryClient", "compartmentId", "discoveryDetails", "freeformTags", "definedTags"})
    public CreateDiscoveryJobDetails(DiscoveryType discoveryType, String discoveryClient, String compartmentId, DiscoveryDetails discoveryDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.discoveryType = discoveryType;
        this.discoveryClient = discoveryClient;
        this.compartmentId = compartmentId;
        this.discoveryDetails = discoveryDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DiscoveryType getDiscoveryType() {
        return this.discoveryType;
    }

    public String getDiscoveryClient() {
        return this.discoveryClient;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public DiscoveryDetails getDiscoveryDetails() {
        return this.discoveryDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDiscoveryJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("discoveryType=").append(String.valueOf((Object)this.discoveryType));
        sb.append(", discoveryClient=").append(String.valueOf(this.discoveryClient));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", discoveryDetails=").append(String.valueOf((Object)this.discoveryDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDiscoveryJobDetails)) {
            return false;
        }
        CreateDiscoveryJobDetails other = (CreateDiscoveryJobDetails)((Object)o);
        return Objects.equals((Object)this.discoveryType, (Object)other.discoveryType) && Objects.equals(this.discoveryClient, other.discoveryClient) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.discoveryDetails, (Object)other.discoveryDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.discoveryType == null ? 43 : this.discoveryType.hashCode());
        result = result * 59 + (this.discoveryClient == null ? 43 : this.discoveryClient.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.discoveryDetails == null ? 43 : this.discoveryDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DiscoveryType implements BmcEnum
    {
        Add("ADD"),
        AddWithRetry("ADD_WITH_RETRY"),
        Refresh("REFRESH");

        private final String value;
        private static Map<String, DiscoveryType> map;

        private DiscoveryType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiscoveryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DiscoveryType: " + key);
        }

        static {
            map = new HashMap<String, DiscoveryType>();
            for (DiscoveryType v : DiscoveryType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="discoveryType")
        private DiscoveryType discoveryType;
        @JsonProperty(value="discoveryClient")
        private String discoveryClient;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="discoveryDetails")
        private DiscoveryDetails discoveryDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType = discoveryType;
            this.__explicitlySet__.add("discoveryType");
            return this;
        }

        public Builder discoveryClient(String discoveryClient) {
            this.discoveryClient = discoveryClient;
            this.__explicitlySet__.add("discoveryClient");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder discoveryDetails(DiscoveryDetails discoveryDetails) {
            this.discoveryDetails = discoveryDetails;
            this.__explicitlySet__.add("discoveryDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateDiscoveryJobDetails build() {
            CreateDiscoveryJobDetails model = new CreateDiscoveryJobDetails(this.discoveryType, this.discoveryClient, this.compartmentId, this.discoveryDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDiscoveryJobDetails model) {
            if (model.wasPropertyExplicitlySet("discoveryType")) {
                this.discoveryType(model.getDiscoveryType());
            }
            if (model.wasPropertyExplicitlySet("discoveryClient")) {
                this.discoveryClient(model.getDiscoveryClient());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("discoveryDetails")) {
                this.discoveryDetails(model.getDiscoveryDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

