/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="connectorId")
    private final String connectorId;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="dbId")
    private final String dbId;
    @JsonProperty(value="sslSecretId")
    private final String sslSecretId;

    @Deprecated
    @ConstructorProperties(value={"protocol", "port", "connectorId", "serviceName", "dbUniqueName", "dbId", "sslSecretId"})
    public ConnectionDetails(Protocol protocol, Integer port, String connectorId, String serviceName, String dbUniqueName, String dbId, String sslSecretId) {
        this.protocol = protocol;
        this.port = port;
        this.connectorId = connectorId;
        this.serviceName = serviceName;
        this.dbUniqueName = dbUniqueName;
        this.dbId = dbId;
        this.sslSecretId = sslSecretId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getDbId() {
        return this.dbId;
    }

    public String getSslSecretId() {
        return this.sslSecretId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", connectorId=").append(String.valueOf(this.connectorId));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", dbId=").append(String.valueOf(this.dbId));
        sb.append(", sslSecretId=").append(String.valueOf(this.sslSecretId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionDetails)) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails)((Object)o);
        return Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals(this.port, other.port) && Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals(this.dbId, other.dbId) && Objects.equals(this.sslSecretId, other.sslSecretId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.connectorId == null ? 43 : this.connectorId.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.dbId == null ? 43 : this.dbId.hashCode());
        result = result * 59 + (this.sslSecretId == null ? 43 : this.sslSecretId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Protocol implements BmcEnum
    {
        Tcp("TCP"),
        Tcps("TCPS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Protocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Protocol.class);
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="connectorId")
        private String connectorId;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="dbId")
        private String dbId;
        @JsonProperty(value="sslSecretId")
        private String sslSecretId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            this.__explicitlySet__.add("connectorId");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder dbId(String dbId) {
            this.dbId = dbId;
            this.__explicitlySet__.add("dbId");
            return this;
        }

        public Builder sslSecretId(String sslSecretId) {
            this.sslSecretId = sslSecretId;
            this.__explicitlySet__.add("sslSecretId");
            return this;
        }

        public ConnectionDetails build() {
            ConnectionDetails model = new ConnectionDetails(this.protocol, this.port, this.connectorId, this.serviceName, this.dbUniqueName, this.dbId, this.sslSecretId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("connectorId")) {
                this.connectorId(model.getConnectorId());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("dbId")) {
                this.dbId(model.getDbId());
            }
            if (model.wasPropertyExplicitlySet("sslSecretId")) {
                this.sslSecretId(model.getSslSecretId());
            }
            return this;
        }
    }
}

