/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring;

import com.oracle.bmc.stackmonitoring.StackMonitoring;
import com.oracle.bmc.stackmonitoring.model.LifecycleState;
import com.oracle.bmc.stackmonitoring.model.ResourceLifecycleState;
import com.oracle.bmc.stackmonitoring.requests.GetDiscoveryJobRequest;
import com.oracle.bmc.stackmonitoring.requests.GetMonitoredResourceRequest;
import com.oracle.bmc.stackmonitoring.requests.GetWorkRequestRequest;
import com.oracle.bmc.stackmonitoring.responses.GetDiscoveryJobResponse;
import com.oracle.bmc.stackmonitoring.responses.GetMonitoredResourceResponse;
import com.oracle.bmc.stackmonitoring.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class StackMonitoringWaiters {
    private final ExecutorService executorService;
    private final StackMonitoring client;

    public StackMonitoringWaiters(ExecutorService executorService, StackMonitoring client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDiscoveryJobRequest, GetDiscoveryJobResponse> forDiscoveryJob(GetDiscoveryJobRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDiscoveryJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDiscoveryJobRequest, GetDiscoveryJobResponse> forDiscoveryJob(GetDiscoveryJobRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDiscoveryJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDiscoveryJobRequest, GetDiscoveryJobResponse> forDiscoveryJob(GetDiscoveryJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDiscoveryJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDiscoveryJobRequest, GetDiscoveryJobResponse> forDiscoveryJob(BmcGenericWaiter waiter, GetDiscoveryJobRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDiscoveryJobRequest, GetDiscoveryJobResponse>(){

            @Override
            public GetDiscoveryJobResponse apply(GetDiscoveryJobRequest request) {
                return StackMonitoringWaiters.this.client.getDiscoveryJob(request);
            }
        }, (Predicate)new Predicate<GetDiscoveryJobResponse>(){

            @Override
            public boolean test(GetDiscoveryJobResponse response) {
                return targetStatesSet.contains((Object)response.getDiscoveryJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMonitoredResourceRequest, GetMonitoredResourceResponse> forMonitoredResource(GetMonitoredResourceRequest request, ResourceLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMonitoredResource(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMonitoredResourceRequest, GetMonitoredResourceResponse> forMonitoredResource(GetMonitoredResourceRequest request, ResourceLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMonitoredResource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMonitoredResourceRequest, GetMonitoredResourceResponse> forMonitoredResource(GetMonitoredResourceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ResourceLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMonitoredResource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMonitoredResourceRequest, GetMonitoredResourceResponse> forMonitoredResource(BmcGenericWaiter waiter, GetMonitoredResourceRequest request, ResourceLifecycleState ... targetStates) {
        final HashSet<ResourceLifecycleState> targetStatesSet = new HashSet<ResourceLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMonitoredResourceRequest, GetMonitoredResourceResponse>(){

            @Override
            public GetMonitoredResourceResponse apply(GetMonitoredResourceRequest request) {
                return StackMonitoringWaiters.this.client.getMonitoredResource(request);
            }
        }, (Predicate)new Predicate<GetMonitoredResourceResponse>(){

            @Override
            public boolean test(GetMonitoredResourceResponse response) {
                return targetStatesSet.contains((Object)response.getMonitoredResource().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ResourceLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return StackMonitoringWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

