/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.stackmonitoring.StackMonitoring;
import com.oracle.bmc.stackmonitoring.model.DiscoveryJobLogSummary;
import com.oracle.bmc.stackmonitoring.model.DiscoveryJobSummary;
import com.oracle.bmc.stackmonitoring.model.WorkRequestError;
import com.oracle.bmc.stackmonitoring.model.WorkRequestLogEntry;
import com.oracle.bmc.stackmonitoring.model.WorkRequestSummary;
import com.oracle.bmc.stackmonitoring.requests.ListDiscoveryJobLogsRequest;
import com.oracle.bmc.stackmonitoring.requests.ListDiscoveryJobsRequest;
import com.oracle.bmc.stackmonitoring.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.stackmonitoring.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.stackmonitoring.requests.ListWorkRequestsRequest;
import com.oracle.bmc.stackmonitoring.responses.ListDiscoveryJobLogsResponse;
import com.oracle.bmc.stackmonitoring.responses.ListDiscoveryJobsResponse;
import com.oracle.bmc.stackmonitoring.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.stackmonitoring.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.stackmonitoring.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class StackMonitoringPaginators {
    private final StackMonitoring client;

    public StackMonitoringPaginators(StackMonitoring client) {
        this.client = client;
    }

    public Iterable<ListDiscoveryJobLogsResponse> listDiscoveryJobLogsResponseIterator(final ListDiscoveryJobLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDiscoveryJobLogsRequest.Builder>(){

            @Override
            public ListDiscoveryJobLogsRequest.Builder get() {
                return ListDiscoveryJobLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDiscoveryJobLogsResponse, String>(){

            @Override
            public String apply(ListDiscoveryJobLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDiscoveryJobLogsRequest.Builder>, ListDiscoveryJobLogsRequest>(){

            @Override
            public ListDiscoveryJobLogsRequest apply(RequestBuilderAndToken<ListDiscoveryJobLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDiscoveryJobLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDiscoveryJobLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDiscoveryJobLogsRequest, ListDiscoveryJobLogsResponse>(){

            @Override
            public ListDiscoveryJobLogsResponse apply(ListDiscoveryJobLogsRequest request) {
                return StackMonitoringPaginators.this.client.listDiscoveryJobLogs(request);
            }
        });
    }

    public Iterable<DiscoveryJobLogSummary> listDiscoveryJobLogsRecordIterator(final ListDiscoveryJobLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDiscoveryJobLogsRequest.Builder>(){

            @Override
            public ListDiscoveryJobLogsRequest.Builder get() {
                return ListDiscoveryJobLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDiscoveryJobLogsResponse, String>(){

            @Override
            public String apply(ListDiscoveryJobLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDiscoveryJobLogsRequest.Builder>, ListDiscoveryJobLogsRequest>(){

            @Override
            public ListDiscoveryJobLogsRequest apply(RequestBuilderAndToken<ListDiscoveryJobLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDiscoveryJobLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDiscoveryJobLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDiscoveryJobLogsRequest, ListDiscoveryJobLogsResponse>(){

            @Override
            public ListDiscoveryJobLogsResponse apply(ListDiscoveryJobLogsRequest request) {
                return StackMonitoringPaginators.this.client.listDiscoveryJobLogs(request);
            }
        }, (Function)new Function<ListDiscoveryJobLogsResponse, List<DiscoveryJobLogSummary>>(){

            @Override
            public List<DiscoveryJobLogSummary> apply(ListDiscoveryJobLogsResponse response) {
                return response.getDiscoveryJobLogCollection().getItems();
            }
        });
    }

    public Iterable<ListDiscoveryJobsResponse> listDiscoveryJobsResponseIterator(final ListDiscoveryJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDiscoveryJobsRequest.Builder>(){

            @Override
            public ListDiscoveryJobsRequest.Builder get() {
                return ListDiscoveryJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDiscoveryJobsResponse, String>(){

            @Override
            public String apply(ListDiscoveryJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDiscoveryJobsRequest.Builder>, ListDiscoveryJobsRequest>(){

            @Override
            public ListDiscoveryJobsRequest apply(RequestBuilderAndToken<ListDiscoveryJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDiscoveryJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDiscoveryJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDiscoveryJobsRequest, ListDiscoveryJobsResponse>(){

            @Override
            public ListDiscoveryJobsResponse apply(ListDiscoveryJobsRequest request) {
                return StackMonitoringPaginators.this.client.listDiscoveryJobs(request);
            }
        });
    }

    public Iterable<DiscoveryJobSummary> listDiscoveryJobsRecordIterator(final ListDiscoveryJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDiscoveryJobsRequest.Builder>(){

            @Override
            public ListDiscoveryJobsRequest.Builder get() {
                return ListDiscoveryJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDiscoveryJobsResponse, String>(){

            @Override
            public String apply(ListDiscoveryJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDiscoveryJobsRequest.Builder>, ListDiscoveryJobsRequest>(){

            @Override
            public ListDiscoveryJobsRequest apply(RequestBuilderAndToken<ListDiscoveryJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDiscoveryJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDiscoveryJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDiscoveryJobsRequest, ListDiscoveryJobsResponse>(){

            @Override
            public ListDiscoveryJobsResponse apply(ListDiscoveryJobsRequest request) {
                return StackMonitoringPaginators.this.client.listDiscoveryJobs(request);
            }
        }, (Function)new Function<ListDiscoveryJobsResponse, List<DiscoveryJobSummary>>(){

            @Override
            public List<DiscoveryJobSummary> apply(ListDiscoveryJobsResponse response) {
                return response.getDiscoveryJobCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return StackMonitoringPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return StackMonitoringPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return StackMonitoringPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return StackMonitoringPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return StackMonitoringPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return StackMonitoringPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

