/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.stackmonitoring;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.stackmonitoring.StackMonitoringAsync;
import com.oracle.bmc.stackmonitoring.model.AssociatedResourcesCollection;
import com.oracle.bmc.stackmonitoring.model.DiscoveryJob;
import com.oracle.bmc.stackmonitoring.model.DiscoveryJobCollection;
import com.oracle.bmc.stackmonitoring.model.DiscoveryJobLogCollection;
import com.oracle.bmc.stackmonitoring.model.MonitoredResource;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceAssociation;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceAssociationsCollection;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceCollection;
import com.oracle.bmc.stackmonitoring.model.MonitoredResourceMembersCollection;
import com.oracle.bmc.stackmonitoring.model.WorkRequest;
import com.oracle.bmc.stackmonitoring.model.WorkRequestErrorCollection;
import com.oracle.bmc.stackmonitoring.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.stackmonitoring.model.WorkRequestSummaryCollection;
import com.oracle.bmc.stackmonitoring.requests.AssociateMonitoredResourcesRequest;
import com.oracle.bmc.stackmonitoring.requests.ChangeMonitoredResourceCompartmentRequest;
import com.oracle.bmc.stackmonitoring.requests.CreateDiscoveryJobRequest;
import com.oracle.bmc.stackmonitoring.requests.CreateMonitoredResourceRequest;
import com.oracle.bmc.stackmonitoring.requests.DeleteDiscoveryJobRequest;
import com.oracle.bmc.stackmonitoring.requests.DeleteMonitoredResourceRequest;
import com.oracle.bmc.stackmonitoring.requests.DisableExternalDatabaseRequest;
import com.oracle.bmc.stackmonitoring.requests.DisassociateMonitoredResourcesRequest;
import com.oracle.bmc.stackmonitoring.requests.GetDiscoveryJobRequest;
import com.oracle.bmc.stackmonitoring.requests.GetMonitoredResourceRequest;
import com.oracle.bmc.stackmonitoring.requests.GetWorkRequestRequest;
import com.oracle.bmc.stackmonitoring.requests.ListDiscoveryJobLogsRequest;
import com.oracle.bmc.stackmonitoring.requests.ListDiscoveryJobsRequest;
import com.oracle.bmc.stackmonitoring.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.stackmonitoring.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.stackmonitoring.requests.ListWorkRequestsRequest;
import com.oracle.bmc.stackmonitoring.requests.SearchAssociatedResourcesRequest;
import com.oracle.bmc.stackmonitoring.requests.SearchMonitoredResourceAssociationsRequest;
import com.oracle.bmc.stackmonitoring.requests.SearchMonitoredResourceMembersRequest;
import com.oracle.bmc.stackmonitoring.requests.SearchMonitoredResourcesRequest;
import com.oracle.bmc.stackmonitoring.requests.UpdateMonitoredResourceRequest;
import com.oracle.bmc.stackmonitoring.responses.AssociateMonitoredResourcesResponse;
import com.oracle.bmc.stackmonitoring.responses.ChangeMonitoredResourceCompartmentResponse;
import com.oracle.bmc.stackmonitoring.responses.CreateDiscoveryJobResponse;
import com.oracle.bmc.stackmonitoring.responses.CreateMonitoredResourceResponse;
import com.oracle.bmc.stackmonitoring.responses.DeleteDiscoveryJobResponse;
import com.oracle.bmc.stackmonitoring.responses.DeleteMonitoredResourceResponse;
import com.oracle.bmc.stackmonitoring.responses.DisableExternalDatabaseResponse;
import com.oracle.bmc.stackmonitoring.responses.DisassociateMonitoredResourcesResponse;
import com.oracle.bmc.stackmonitoring.responses.GetDiscoveryJobResponse;
import com.oracle.bmc.stackmonitoring.responses.GetMonitoredResourceResponse;
import com.oracle.bmc.stackmonitoring.responses.GetWorkRequestResponse;
import com.oracle.bmc.stackmonitoring.responses.ListDiscoveryJobLogsResponse;
import com.oracle.bmc.stackmonitoring.responses.ListDiscoveryJobsResponse;
import com.oracle.bmc.stackmonitoring.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.stackmonitoring.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.stackmonitoring.responses.ListWorkRequestsResponse;
import com.oracle.bmc.stackmonitoring.responses.SearchAssociatedResourcesResponse;
import com.oracle.bmc.stackmonitoring.responses.SearchMonitoredResourceAssociationsResponse;
import com.oracle.bmc.stackmonitoring.responses.SearchMonitoredResourceMembersResponse;
import com.oracle.bmc.stackmonitoring.responses.SearchMonitoredResourcesResponse;
import com.oracle.bmc.stackmonitoring.responses.UpdateMonitoredResourceResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackMonitoringAsyncClient
extends BaseAsyncClient
implements StackMonitoringAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STACKMONITORING").serviceEndpointPrefix("").serviceEndpointTemplate("https://stack-monitoring.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(StackMonitoringAsyncClient.class);

    private StackMonitoringAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AssociateMonitoredResourcesResponse> associateMonitoredResources(AssociateMonitoredResourcesRequest request, AsyncHandler<AssociateMonitoredResourcesRequest, AssociateMonitoredResourcesResponse> handler) {
        Objects.requireNonNull(request.getAssociateMonitoredResourcesDetails(), "associateMonitoredResourcesDetails is required");
        return this.clientCall(request, AssociateMonitoredResourcesResponse::builder).logger(LOG, "associateMonitoredResources").serviceDetails("StackMonitoring", "AssociateMonitoredResources", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/AssociateMonitoredResources").method(Method.POST).requestBuilder(AssociateMonitoredResourcesRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam("actions").appendPathParam("associateMonitoredResources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(MonitoredResourceAssociation.class, AssociateMonitoredResourcesResponse.Builder::monitoredResourceAssociation).handleResponseHeaderString("etag", AssociateMonitoredResourcesResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AssociateMonitoredResourcesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeMonitoredResourceCompartmentResponse> changeMonitoredResourceCompartment(ChangeMonitoredResourceCompartmentRequest request, AsyncHandler<ChangeMonitoredResourceCompartmentRequest, ChangeMonitoredResourceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getMonitoredResourceId(), (String)"monitoredResourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMonitoredResourceCompartmentDetails(), "changeMonitoredResourceCompartmentDetails is required");
        return this.clientCall(request, ChangeMonitoredResourceCompartmentResponse::builder).logger(LOG, "changeMonitoredResourceCompartment").serviceDetails("StackMonitoring", "ChangeMonitoredResourceCompartment", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/ChangeMonitoredResourceCompartment").method(Method.POST).requestBuilder(ChangeMonitoredResourceCompartmentRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam(request.getMonitoredResourceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeMonitoredResourceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeMonitoredResourceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDiscoveryJobResponse> createDiscoveryJob(CreateDiscoveryJobRequest request, AsyncHandler<CreateDiscoveryJobRequest, CreateDiscoveryJobResponse> handler) {
        Objects.requireNonNull(request.getCreateDiscoveryJobDetails(), "createDiscoveryJobDetails is required");
        return this.clientCall(request, CreateDiscoveryJobResponse::builder).logger(LOG, "createDiscoveryJob").serviceDetails("StackMonitoring", "CreateDiscoveryJob", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/DiscoveryJob/CreateDiscoveryJob").method(Method.POST).requestBuilder(CreateDiscoveryJobRequest::builder).basePath("/20210330").appendPathParam("discoveryJobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DiscoveryJob.class, CreateDiscoveryJobResponse.Builder::discoveryJob).handleResponseHeaderString("etag", CreateDiscoveryJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDiscoveryJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateMonitoredResourceResponse> createMonitoredResource(CreateMonitoredResourceRequest request, AsyncHandler<CreateMonitoredResourceRequest, CreateMonitoredResourceResponse> handler) {
        Objects.requireNonNull(request.getCreateMonitoredResourceDetails(), "createMonitoredResourceDetails is required");
        return this.clientCall(request, CreateMonitoredResourceResponse::builder).logger(LOG, "createMonitoredResource").serviceDetails("StackMonitoring", "CreateMonitoredResource", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/CreateMonitoredResource").method(Method.POST).requestBuilder(CreateMonitoredResourceRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("external-resource-id", request.getExternalResourceId()).hasBody().handleBody(MonitoredResource.class, CreateMonitoredResourceResponse.Builder::monitoredResource).handleResponseHeaderString("opc-work-request-id", CreateMonitoredResourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateMonitoredResourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-monitored-resource-id", CreateMonitoredResourceResponse.Builder::opcMonitoredResourceId).handleResponseHeaderString("location", CreateMonitoredResourceResponse.Builder::location).handleResponseHeaderString("content-location", CreateMonitoredResourceResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateMonitoredResourceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteDiscoveryJobResponse> deleteDiscoveryJob(DeleteDiscoveryJobRequest request, AsyncHandler<DeleteDiscoveryJobRequest, DeleteDiscoveryJobResponse> handler) {
        Validate.notBlank((String)request.getDiscoveryJobId(), (String)"discoveryJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDiscoveryJobResponse::builder).logger(LOG, "deleteDiscoveryJob").serviceDetails("StackMonitoring", "DeleteDiscoveryJob", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/DiscoveryJob/DeleteDiscoveryJob").method(Method.DELETE).requestBuilder(DeleteDiscoveryJobRequest::builder).basePath("/20210330").appendPathParam("discoveryJobs").appendPathParam(request.getDiscoveryJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDiscoveryJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteMonitoredResourceResponse> deleteMonitoredResource(DeleteMonitoredResourceRequest request, AsyncHandler<DeleteMonitoredResourceRequest, DeleteMonitoredResourceResponse> handler) {
        Validate.notBlank((String)request.getMonitoredResourceId(), (String)"monitoredResourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteMonitoredResourceResponse::builder).logger(LOG, "deleteMonitoredResource").serviceDetails("StackMonitoring", "DeleteMonitoredResource", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/DeleteMonitoredResource").method(Method.DELETE).requestBuilder(DeleteMonitoredResourceRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam(request.getMonitoredResourceId()).appendQueryParam("isDeleteMembers", (Object)request.getIsDeleteMembers()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteMonitoredResourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMonitoredResourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableExternalDatabaseResponse> disableExternalDatabase(DisableExternalDatabaseRequest request, AsyncHandler<DisableExternalDatabaseRequest, DisableExternalDatabaseResponse> handler) {
        Validate.notBlank((String)request.getMonitoredResourceId(), (String)"monitoredResourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DisableExternalDatabaseResponse::builder).logger(LOG, "disableExternalDatabase").serviceDetails("StackMonitoring", "DisableExternalDatabase", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/DisableExternalDatabase").method(Method.POST).requestBuilder(DisableExternalDatabaseRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam(request.getMonitoredResourceId()).appendPathParam("actions").appendPathParam("disableExternalDatabase").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DisableExternalDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableExternalDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisassociateMonitoredResourcesResponse> disassociateMonitoredResources(DisassociateMonitoredResourcesRequest request, AsyncHandler<DisassociateMonitoredResourcesRequest, DisassociateMonitoredResourcesResponse> handler) {
        Objects.requireNonNull(request.getDisassociateMonitoredResourcesDetails(), "disassociateMonitoredResourcesDetails is required");
        return this.clientCall(request, DisassociateMonitoredResourcesResponse::builder).logger(LOG, "disassociateMonitoredResources").serviceDetails("StackMonitoring", "DisassociateMonitoredResources", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/DisassociateMonitoredResources").method(Method.POST).requestBuilder(DisassociateMonitoredResourcesRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam("actions").appendPathParam("disassociateMonitoredResources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", DisassociateMonitoredResourcesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDiscoveryJobResponse> getDiscoveryJob(GetDiscoveryJobRequest request, AsyncHandler<GetDiscoveryJobRequest, GetDiscoveryJobResponse> handler) {
        Validate.notBlank((String)request.getDiscoveryJobId(), (String)"discoveryJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDiscoveryJobResponse::builder).logger(LOG, "getDiscoveryJob").serviceDetails("StackMonitoring", "GetDiscoveryJob", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/DiscoveryJob/GetDiscoveryJob").method(Method.GET).requestBuilder(GetDiscoveryJobRequest::builder).basePath("/20210330").appendPathParam("discoveryJobs").appendPathParam(request.getDiscoveryJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DiscoveryJob.class, GetDiscoveryJobResponse.Builder::discoveryJob).handleResponseHeaderString("etag", GetDiscoveryJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDiscoveryJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMonitoredResourceResponse> getMonitoredResource(GetMonitoredResourceRequest request, AsyncHandler<GetMonitoredResourceRequest, GetMonitoredResourceResponse> handler) {
        Validate.notBlank((String)request.getMonitoredResourceId(), (String)"monitoredResourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMonitoredResourceResponse::builder).logger(LOG, "getMonitoredResource").serviceDetails("StackMonitoring", "GetMonitoredResource", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/GetMonitoredResource").method(Method.GET).requestBuilder(GetMonitoredResourceRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam(request.getMonitoredResourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MonitoredResource.class, GetMonitoredResourceResponse.Builder::monitoredResource).handleResponseHeaderString("etag", GetMonitoredResourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMonitoredResourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("StackMonitoring", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210330").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListDiscoveryJobLogsResponse> listDiscoveryJobLogs(ListDiscoveryJobLogsRequest request, AsyncHandler<ListDiscoveryJobLogsRequest, ListDiscoveryJobLogsResponse> handler) {
        Validate.notBlank((String)request.getDiscoveryJobId(), (String)"discoveryJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDiscoveryJobLogsResponse::builder).logger(LOG, "listDiscoveryJobLogs").serviceDetails("StackMonitoring", "ListDiscoveryJobLogs", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/DiscoveryJobLogCollection/ListDiscoveryJobLogs").method(Method.GET).requestBuilder(ListDiscoveryJobLogsRequest::builder).basePath("/20210330").appendPathParam("discoveryJobs").appendPathParam(request.getDiscoveryJobId()).appendPathParam("logs").appendEnumQueryParam("logType", (BmcEnum)request.getLogType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DiscoveryJobLogCollection.class, ListDiscoveryJobLogsResponse.Builder::discoveryJobLogCollection).handleResponseHeaderString("opc-next-page", ListDiscoveryJobLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDiscoveryJobLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDiscoveryJobsResponse> listDiscoveryJobs(ListDiscoveryJobsRequest request, AsyncHandler<ListDiscoveryJobsRequest, ListDiscoveryJobsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDiscoveryJobsResponse::builder).logger(LOG, "listDiscoveryJobs").serviceDetails("StackMonitoring", "ListDiscoveryJobs", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/DiscoveryJobCollection/ListDiscoveryJobs").method(Method.GET).requestBuilder(ListDiscoveryJobsRequest::builder).basePath("/20210330").appendPathParam("discoveryJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DiscoveryJobCollection.class, ListDiscoveryJobsResponse.Builder::discoveryJobCollection).handleResponseHeaderString("opc-next-page", ListDiscoveryJobsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDiscoveryJobsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("StackMonitoring", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210330").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("StackMonitoring", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210330").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("StackMonitoring", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/WorkRequestSummaryCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210330").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SearchAssociatedResourcesResponse> searchAssociatedResources(SearchAssociatedResourcesRequest request, AsyncHandler<SearchAssociatedResourcesRequest, SearchAssociatedResourcesResponse> handler) {
        Objects.requireNonNull(request.getSearchAssociatedResourcesDetails(), "searchAssociatedResourcesDetails is required");
        return this.clientCall(request, SearchAssociatedResourcesResponse::builder).logger(LOG, "searchAssociatedResources").serviceDetails("StackMonitoring", "SearchAssociatedResources", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/SearchAssociatedResources").method(Method.POST).requestBuilder(SearchAssociatedResourcesRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam("actions").appendPathParam("searchAssociatedResources").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendListQueryParam("excludeFields", request.getExcludeFields(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(AssociatedResourcesCollection.class, SearchAssociatedResourcesResponse.Builder::associatedResourcesCollection).handleResponseHeaderString("opc-request-id", SearchAssociatedResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchAssociatedResourcesResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", SearchAssociatedResourcesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<SearchMonitoredResourceAssociationsResponse> searchMonitoredResourceAssociations(SearchMonitoredResourceAssociationsRequest request, AsyncHandler<SearchMonitoredResourceAssociationsRequest, SearchMonitoredResourceAssociationsResponse> handler) {
        Objects.requireNonNull(request.getSearchMonitoredResourceAssociationsDetails(), "searchMonitoredResourceAssociationsDetails is required");
        return this.clientCall(request, SearchMonitoredResourceAssociationsResponse::builder).logger(LOG, "searchMonitoredResourceAssociations").serviceDetails("StackMonitoring", "SearchMonitoredResourceAssociations", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/SearchMonitoredResourceAssociations").method(Method.POST).requestBuilder(SearchMonitoredResourceAssociationsRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam("actions").appendPathParam("searchAssociations").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(MonitoredResourceAssociationsCollection.class, SearchMonitoredResourceAssociationsResponse.Builder::monitoredResourceAssociationsCollection).handleResponseHeaderString("opc-request-id", SearchMonitoredResourceAssociationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchMonitoredResourceAssociationsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", SearchMonitoredResourceAssociationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<SearchMonitoredResourceMembersResponse> searchMonitoredResourceMembers(SearchMonitoredResourceMembersRequest request, AsyncHandler<SearchMonitoredResourceMembersRequest, SearchMonitoredResourceMembersResponse> handler) {
        Validate.notBlank((String)request.getMonitoredResourceId(), (String)"monitoredResourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSearchMonitoredResourceMembersDetails(), "searchMonitoredResourceMembersDetails is required");
        return this.clientCall(request, SearchMonitoredResourceMembersResponse::builder).logger(LOG, "searchMonitoredResourceMembers").serviceDetails("StackMonitoring", "SearchMonitoredResourceMembers", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/SearchMonitoredResourceMembers").method(Method.POST).requestBuilder(SearchMonitoredResourceMembersRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam(request.getMonitoredResourceId()).appendPathParam("actions").appendPathParam("listMembers").appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(MonitoredResourceMembersCollection.class, SearchMonitoredResourceMembersResponse.Builder::monitoredResourceMembersCollection).handleResponseHeaderString("opc-request-id", SearchMonitoredResourceMembersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchMonitoredResourceMembersResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", SearchMonitoredResourceMembersResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<SearchMonitoredResourcesResponse> searchMonitoredResources(SearchMonitoredResourcesRequest request, AsyncHandler<SearchMonitoredResourcesRequest, SearchMonitoredResourcesResponse> handler) {
        Objects.requireNonNull(request.getSearchMonitoredResourcesDetails(), "searchMonitoredResourcesDetails is required");
        return this.clientCall(request, SearchMonitoredResourcesResponse::builder).logger(LOG, "searchMonitoredResources").serviceDetails("StackMonitoring", "SearchMonitoredResources", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/SearchMonitoredResources").method(Method.POST).requestBuilder(SearchMonitoredResourcesRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam("actions").appendPathParam("search").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendListQueryParam("excludeFields", request.getExcludeFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(MonitoredResourceCollection.class, SearchMonitoredResourcesResponse.Builder::monitoredResourceCollection).handleResponseHeaderString("opc-request-id", SearchMonitoredResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchMonitoredResourcesResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", SearchMonitoredResourcesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<UpdateMonitoredResourceResponse> updateMonitoredResource(UpdateMonitoredResourceRequest request, AsyncHandler<UpdateMonitoredResourceRequest, UpdateMonitoredResourceResponse> handler) {
        Validate.notBlank((String)request.getMonitoredResourceId(), (String)"monitoredResourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMonitoredResourceDetails(), "updateMonitoredResourceDetails is required");
        return this.clientCall(request, UpdateMonitoredResourceResponse::builder).logger(LOG, "updateMonitoredResource").serviceDetails("StackMonitoring", "UpdateMonitoredResource", "https://docs.oracle.com/iaas/api/#/en/stack-monitoring/20210330/MonitoredResource/UpdateMonitoredResource").method(Method.PUT).requestBuilder(UpdateMonitoredResourceRequest::builder).basePath("/20210330").appendPathParam("monitoredResources").appendPathParam(request.getMonitoredResourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateMonitoredResourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateMonitoredResourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public StackMonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)StackMonitoringAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StackMonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(StackMonitoringAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StackMonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)StackMonitoringAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StackMonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)StackMonitoringAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public StackMonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)StackMonitoringAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public StackMonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)StackMonitoringAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public StackMonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)StackMonitoringAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StackMonitoringAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public StackMonitoringAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new StackMonitoringAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

