/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.servicemesh.model.CaBundle;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IngressListenerClientValidationConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="trustedCaBundle")
    private final CaBundle trustedCaBundle;
    @JsonProperty(value="subjectAlternateNames")
    private final List<String> subjectAlternateNames;

    @Deprecated
    @ConstructorProperties(value={"trustedCaBundle", "subjectAlternateNames"})
    public IngressListenerClientValidationConfig(CaBundle trustedCaBundle, List<String> subjectAlternateNames) {
        this.trustedCaBundle = trustedCaBundle;
        this.subjectAlternateNames = subjectAlternateNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public CaBundle getTrustedCaBundle() {
        return this.trustedCaBundle;
    }

    public List<String> getSubjectAlternateNames() {
        return this.subjectAlternateNames;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IngressListenerClientValidationConfig(");
        sb.append("super=").append(super.toString());
        sb.append("trustedCaBundle=").append(String.valueOf((Object)this.trustedCaBundle));
        sb.append(", subjectAlternateNames=").append(String.valueOf(this.subjectAlternateNames));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngressListenerClientValidationConfig)) {
            return false;
        }
        IngressListenerClientValidationConfig other = (IngressListenerClientValidationConfig)((Object)o);
        return Objects.equals((Object)this.trustedCaBundle, (Object)other.trustedCaBundle) && Objects.equals(this.subjectAlternateNames, other.subjectAlternateNames) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.trustedCaBundle == null ? 43 : this.trustedCaBundle.hashCode());
        result = result * 59 + (this.subjectAlternateNames == null ? 43 : this.subjectAlternateNames.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="trustedCaBundle")
        private CaBundle trustedCaBundle;
        @JsonProperty(value="subjectAlternateNames")
        private List<String> subjectAlternateNames;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder trustedCaBundle(CaBundle trustedCaBundle) {
            this.trustedCaBundle = trustedCaBundle;
            this.__explicitlySet__.add("trustedCaBundle");
            return this;
        }

        public Builder subjectAlternateNames(List<String> subjectAlternateNames) {
            this.subjectAlternateNames = subjectAlternateNames;
            this.__explicitlySet__.add("subjectAlternateNames");
            return this;
        }

        public IngressListenerClientValidationConfig build() {
            IngressListenerClientValidationConfig model = new IngressListenerClientValidationConfig(this.trustedCaBundle, this.subjectAlternateNames);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IngressListenerClientValidationConfig model) {
            if (model.wasPropertyExplicitlySet("trustedCaBundle")) {
                this.trustedCaBundle(model.getTrustedCaBundle());
            }
            if (model.wasPropertyExplicitlySet("subjectAlternateNames")) {
                this.subjectAlternateNames(model.getSubjectAlternateNames());
            }
            return this;
        }
    }
}

