/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.responses;

import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.servicecatalog.model.PrivateApplication;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UpdatePrivateApplicationResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcWorkRequestId;
    private String etag;
    private PrivateApplication privateApplication;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public PrivateApplication getPrivateApplication() {
        return this.privateApplication;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcWorkRequestId", "etag", "privateApplication"})
    private UpdatePrivateApplicationResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcWorkRequestId, String etag, PrivateApplication privateApplication) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.etag = etag;
        this.privateApplication = privateApplication;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",privateApplication=").append(String.valueOf((Object)this.privateApplication));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePrivateApplicationResponse)) {
            return false;
        }
        UpdatePrivateApplicationResponse other = (UpdatePrivateApplicationResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.privateApplication, (Object)other.privateApplication);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.privateApplication == null ? 43 : this.privateApplication.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<UpdatePrivateApplicationResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcWorkRequestId;
        private String etag;
        private PrivateApplication privateApplication;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder privateApplication(PrivateApplication privateApplication) {
            this.privateApplication = privateApplication;
            return this;
        }

        public Builder copy(UpdatePrivateApplicationResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.etag(o.getEtag());
            this.privateApplication(o.getPrivateApplication());
            return this;
        }

        public UpdatePrivateApplicationResponse build() {
            return new UpdatePrivateApplicationResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcWorkRequestId, this.etag, this.privateApplication);
        }
    }
}

