/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.servicecatalog.model.UpdatePrivateApplicationDetails;
import java.util.Objects;

public class UpdatePrivateApplicationRequest
extends BmcRequest<UpdatePrivateApplicationDetails> {
    private String privateApplicationId;
    private UpdatePrivateApplicationDetails updatePrivateApplicationDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getPrivateApplicationId() {
        return this.privateApplicationId;
    }

    public UpdatePrivateApplicationDetails getUpdatePrivateApplicationDetails() {
        return this.updatePrivateApplicationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdatePrivateApplicationDetails getBody$() {
        return this.updatePrivateApplicationDetails;
    }

    public Builder toBuilder() {
        return new Builder().privateApplicationId(this.privateApplicationId).updatePrivateApplicationDetails(this.updatePrivateApplicationDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",privateApplicationId=").append(String.valueOf(this.privateApplicationId));
        sb.append(",updatePrivateApplicationDetails=").append(String.valueOf((Object)this.updatePrivateApplicationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePrivateApplicationRequest)) {
            return false;
        }
        UpdatePrivateApplicationRequest other = (UpdatePrivateApplicationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.privateApplicationId, other.privateApplicationId) && Objects.equals((Object)this.updatePrivateApplicationDetails, (Object)other.updatePrivateApplicationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.privateApplicationId == null ? 43 : this.privateApplicationId.hashCode());
        result = result * 59 + (this.updatePrivateApplicationDetails == null ? 43 : this.updatePrivateApplicationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePrivateApplicationRequest, UpdatePrivateApplicationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String privateApplicationId = null;
        private UpdatePrivateApplicationDetails updatePrivateApplicationDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder privateApplicationId(String privateApplicationId) {
            this.privateApplicationId = privateApplicationId;
            return this;
        }

        public Builder updatePrivateApplicationDetails(UpdatePrivateApplicationDetails updatePrivateApplicationDetails) {
            this.updatePrivateApplicationDetails = updatePrivateApplicationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePrivateApplicationRequest o) {
            this.privateApplicationId(o.getPrivateApplicationId());
            this.updatePrivateApplicationDetails(o.getUpdatePrivateApplicationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePrivateApplicationRequest build() {
            UpdatePrivateApplicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePrivateApplicationDetails body) {
            this.updatePrivateApplicationDetails(body);
            return this;
        }

        public UpdatePrivateApplicationRequest buildWithoutInvocationCallback() {
            UpdatePrivateApplicationRequest request = new UpdatePrivateApplicationRequest();
            request.privateApplicationId = this.privateApplicationId;
            request.updatePrivateApplicationDetails = this.updatePrivateApplicationDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

