/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.servicecatalog.model.PackageTypeEnum;
import com.oracle.bmc.servicecatalog.model.PricingTypeEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListApplicationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String serviceCatalogId;
    private String entityType;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private String displayName;
    private String entityId;
    private List<String> publisherId;
    private List<PackageTypeEnum> packageType;
    private List<PricingTypeEnum> pricing;
    private Boolean isFeatured;
    private SortOrder sortOrder;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getServiceCatalogId() {
        return this.serviceCatalogId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public List<String> getPublisherId() {
        return this.publisherId;
    }

    public List<PackageTypeEnum> getPackageType() {
        return this.packageType;
    }

    public List<PricingTypeEnum> getPricing() {
        return this.pricing;
    }

    public Boolean getIsFeatured() {
        return this.isFeatured;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).serviceCatalogId(this.serviceCatalogId).entityType(this.entityType).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).displayName(this.displayName).entityId(this.entityId).publisherId(this.publisherId).packageType(this.packageType).pricing(this.pricing).isFeatured(this.isFeatured).sortOrder(this.sortOrder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",serviceCatalogId=").append(String.valueOf(this.serviceCatalogId));
        sb.append(",entityType=").append(String.valueOf(this.entityType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",entityId=").append(String.valueOf(this.entityId));
        sb.append(",publisherId=").append(String.valueOf(this.publisherId));
        sb.append(",packageType=").append(String.valueOf(this.packageType));
        sb.append(",pricing=").append(String.valueOf(this.pricing));
        sb.append(",isFeatured=").append(String.valueOf(this.isFeatured));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.serviceCatalogId, other.serviceCatalogId) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.entityId, other.entityId) && Objects.equals(this.publisherId, other.publisherId) && Objects.equals(this.packageType, other.packageType) && Objects.equals(this.pricing, other.pricing) && Objects.equals(this.isFeatured, other.isFeatured) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.serviceCatalogId == null ? 43 : this.serviceCatalogId.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.publisherId == null ? 43 : this.publisherId.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.pricing == null ? 43 : this.pricing.hashCode());
        result = result * 59 + (this.isFeatured == null ? 43 : this.isFeatured.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListApplicationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String serviceCatalogId = null;
        private String entityType = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private String displayName = null;
        private String entityId = null;
        private List<String> publisherId = null;
        private List<PackageTypeEnum> packageType = null;
        private List<PricingTypeEnum> pricing = null;
        private Boolean isFeatured = null;
        private SortOrder sortOrder = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder serviceCatalogId(String serviceCatalogId) {
            this.serviceCatalogId = serviceCatalogId;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder publisherId(List<String> publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public Builder publisherId(String singularValue) {
            return this.publisherId(Arrays.asList(singularValue));
        }

        public Builder packageType(List<PackageTypeEnum> packageType) {
            this.packageType = packageType;
            return this;
        }

        public Builder packageType(PackageTypeEnum singularValue) {
            return this.packageType(Arrays.asList(singularValue));
        }

        public Builder pricing(List<PricingTypeEnum> pricing) {
            this.pricing = pricing;
            return this;
        }

        public Builder pricing(PricingTypeEnum singularValue) {
            return this.pricing(Arrays.asList(singularValue));
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListApplicationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.serviceCatalogId(o.getServiceCatalogId());
            this.entityType(o.getEntityType());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.displayName(o.getDisplayName());
            this.entityId(o.getEntityId());
            this.publisherId(o.getPublisherId());
            this.packageType(o.getPackageType());
            this.pricing(o.getPricing());
            this.isFeatured(o.getIsFeatured());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListApplicationsRequest build() {
            ListApplicationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListApplicationsRequest buildWithoutInvocationCallback() {
            ListApplicationsRequest request = new ListApplicationsRequest();
            request.compartmentId = this.compartmentId;
            request.serviceCatalogId = this.serviceCatalogId;
            request.entityType = this.entityType;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.displayName = this.displayName;
            request.entityId = this.entityId;
            request.publisherId = this.publisherId;
            request.packageType = this.packageType;
            request.pricing = this.pricing;
            request.isFeatured = this.isFeatured;
            request.sortOrder = this.sortOrder;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

