/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPrivateApplicationPackageActionDownloadConfigRequest
extends BmcRequest<Void> {
    private String privateApplicationPackageId;
    private String opcRequestId;

    public String getPrivateApplicationPackageId() {
        return this.privateApplicationPackageId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().privateApplicationPackageId(this.privateApplicationPackageId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",privateApplicationPackageId=").append(String.valueOf(this.privateApplicationPackageId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPrivateApplicationPackageActionDownloadConfigRequest)) {
            return false;
        }
        GetPrivateApplicationPackageActionDownloadConfigRequest other = (GetPrivateApplicationPackageActionDownloadConfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.privateApplicationPackageId, other.privateApplicationPackageId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.privateApplicationPackageId == null ? 43 : this.privateApplicationPackageId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPrivateApplicationPackageActionDownloadConfigRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String privateApplicationPackageId = null;
        private String opcRequestId = null;

        public Builder privateApplicationPackageId(String privateApplicationPackageId) {
            this.privateApplicationPackageId = privateApplicationPackageId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPrivateApplicationPackageActionDownloadConfigRequest o) {
            this.privateApplicationPackageId(o.getPrivateApplicationPackageId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPrivateApplicationPackageActionDownloadConfigRequest build() {
            GetPrivateApplicationPackageActionDownloadConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPrivateApplicationPackageActionDownloadConfigRequest buildWithoutInvocationCallback() {
            GetPrivateApplicationPackageActionDownloadConfigRequest request = new GetPrivateApplicationPackageActionDownloadConfigRequest();
            request.privateApplicationPackageId = this.privateApplicationPackageId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

