/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteServiceCatalogAssociationRequest
extends BmcRequest<Void> {
    private String serviceCatalogAssociationId;
    private String ifMatch;
    private String opcRequestId;

    public String getServiceCatalogAssociationId() {
        return this.serviceCatalogAssociationId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().serviceCatalogAssociationId(this.serviceCatalogAssociationId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",serviceCatalogAssociationId=").append(String.valueOf(this.serviceCatalogAssociationId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteServiceCatalogAssociationRequest)) {
            return false;
        }
        DeleteServiceCatalogAssociationRequest other = (DeleteServiceCatalogAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.serviceCatalogAssociationId, other.serviceCatalogAssociationId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.serviceCatalogAssociationId == null ? 43 : this.serviceCatalogAssociationId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteServiceCatalogAssociationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String serviceCatalogAssociationId = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder serviceCatalogAssociationId(String serviceCatalogAssociationId) {
            this.serviceCatalogAssociationId = serviceCatalogAssociationId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteServiceCatalogAssociationRequest o) {
            this.serviceCatalogAssociationId(o.getServiceCatalogAssociationId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteServiceCatalogAssociationRequest build() {
            DeleteServiceCatalogAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteServiceCatalogAssociationRequest buildWithoutInvocationCallback() {
            DeleteServiceCatalogAssociationRequest request = new DeleteServiceCatalogAssociationRequest();
            request.serviceCatalogAssociationId = this.serviceCatalogAssociationId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

