/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.servicecatalog.model.ActionType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="actionType")
    private final ActionType actionType;
    @JsonProperty(value="entityId")
    private final String entityId;
    @JsonProperty(value="entityUri")
    private final String entityUri;

    @Deprecated
    @ConstructorProperties(value={"entityType", "actionType", "entityId", "entityUri"})
    public WorkRequestResource(String entityType, ActionType actionType, String entityId, String entityUri) {
        this.entityType = entityType;
        this.actionType = actionType;
        this.entityId = entityId;
        this.entityUri = entityUri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityUri() {
        return this.entityUri;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestResource(");
        sb.append("super=").append(super.toString());
        sb.append("entityType=").append(String.valueOf(this.entityType));
        sb.append(", actionType=").append(String.valueOf((Object)this.actionType));
        sb.append(", entityId=").append(String.valueOf(this.entityId));
        sb.append(", entityUri=").append(String.valueOf(this.entityUri));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestResource)) {
            return false;
        }
        WorkRequestResource other = (WorkRequestResource)((Object)o);
        return Objects.equals(this.entityType, other.entityType) && Objects.equals((Object)this.actionType, (Object)other.actionType) && Objects.equals(this.entityId, other.entityId) && Objects.equals(this.entityUri, other.entityUri) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.actionType == null ? 43 : this.actionType.hashCode());
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.entityUri == null ? 43 : this.entityUri.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="actionType")
        private ActionType actionType;
        @JsonProperty(value="entityId")
        private String entityId;
        @JsonProperty(value="entityUri")
        private String entityUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder actionType(ActionType actionType) {
            this.actionType = actionType;
            this.__explicitlySet__.add("actionType");
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.__explicitlySet__.add("entityId");
            return this;
        }

        public Builder entityUri(String entityUri) {
            this.entityUri = entityUri;
            this.__explicitlySet__.add("entityUri");
            return this;
        }

        public WorkRequestResource build() {
            WorkRequestResource model = new WorkRequestResource(this.entityType, this.actionType, this.entityId, this.entityUri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestResource model) {
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("actionType")) {
                this.actionType(model.getActionType());
            }
            if (model.wasPropertyExplicitlySet("entityId")) {
                this.entityId(model.getEntityId());
            }
            if (model.wasPropertyExplicitlySet("entityUri")) {
                this.entityUri(model.getEntityUri());
            }
            return this;
        }
    }
}

