/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ServiceCatalogAssociation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="serviceCatalogId")
    private final String serviceCatalogId;
    @JsonProperty(value="entityId")
    private final String entityId;
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"id", "serviceCatalogId", "entityId", "entityType", "timeCreated"})
    public ServiceCatalogAssociation(String id, String serviceCatalogId, String entityId, String entityType, Date timeCreated) {
        this.id = id;
        this.serviceCatalogId = serviceCatalogId;
        this.entityId = entityId;
        this.entityType = entityType;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getServiceCatalogId() {
        return this.serviceCatalogId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceCatalogAssociation(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", serviceCatalogId=").append(String.valueOf(this.serviceCatalogId));
        sb.append(", entityId=").append(String.valueOf(this.entityId));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceCatalogAssociation)) {
            return false;
        }
        ServiceCatalogAssociation other = (ServiceCatalogAssociation)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.serviceCatalogId, other.serviceCatalogId) && Objects.equals(this.entityId, other.entityId) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.serviceCatalogId == null ? 43 : this.serviceCatalogId.hashCode());
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="serviceCatalogId")
        private String serviceCatalogId;
        @JsonProperty(value="entityId")
        private String entityId;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder serviceCatalogId(String serviceCatalogId) {
            this.serviceCatalogId = serviceCatalogId;
            this.__explicitlySet__.add("serviceCatalogId");
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.__explicitlySet__.add("entityId");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public ServiceCatalogAssociation build() {
            ServiceCatalogAssociation model = new ServiceCatalogAssociation(this.id, this.serviceCatalogId, this.entityId, this.entityType, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ServiceCatalogAssociation model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("serviceCatalogId")) {
                this.serviceCatalogId(model.getServiceCatalogId());
            }
            if (model.wasPropertyExplicitlySet("entityId")) {
                this.entityId(model.getEntityId());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

