/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.servicecatalog.model.PrivateApplicationPackage;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="packageType")
@JsonFilter(value="explicitlySetFilter")
public final class PrivateApplicationStackPackage
extends PrivateApplicationPackage {
    @JsonProperty(value="contentUrl")
    private final String contentUrl;
    @JsonProperty(value="mimeType")
    private final String mimeType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PrivateApplicationStackPackage(String id, String privateApplicationId, String displayName, String version, Date timeCreated, String contentUrl, String mimeType) {
        super(id, privateApplicationId, displayName, version, timeCreated);
        this.contentUrl = contentUrl;
        this.mimeType = mimeType;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PrivateApplicationStackPackage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", contentUrl=").append(String.valueOf(this.contentUrl));
        sb.append(", mimeType=").append(String.valueOf(this.mimeType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrivateApplicationStackPackage)) {
            return false;
        }
        PrivateApplicationStackPackage other = (PrivateApplicationStackPackage)((Object)o);
        return Objects.equals(this.contentUrl, other.contentUrl) && Objects.equals(this.mimeType, other.mimeType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.contentUrl == null ? 43 : this.contentUrl.hashCode());
        result = result * 59 + (this.mimeType == null ? 43 : this.mimeType.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="privateApplicationId")
        private String privateApplicationId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="contentUrl")
        private String contentUrl;
        @JsonProperty(value="mimeType")
        private String mimeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder privateApplicationId(String privateApplicationId) {
            this.privateApplicationId = privateApplicationId;
            this.__explicitlySet__.add("privateApplicationId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            this.__explicitlySet__.add("contentUrl");
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            this.__explicitlySet__.add("mimeType");
            return this;
        }

        public PrivateApplicationStackPackage build() {
            PrivateApplicationStackPackage model = new PrivateApplicationStackPackage(this.id, this.privateApplicationId, this.displayName, this.version, this.timeCreated, this.contentUrl, this.mimeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PrivateApplicationStackPackage model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("privateApplicationId")) {
                this.privateApplicationId(model.getPrivateApplicationId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("contentUrl")) {
                this.contentUrl(model.getContentUrl());
            }
            if (model.wasPropertyExplicitlySet("mimeType")) {
                this.mimeType(model.getMimeType());
            }
            return this;
        }
    }
}

