/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.servicecatalog.model.PackageTypeEnum;
import com.oracle.bmc.servicecatalog.model.PricingTypeEnum;
import com.oracle.bmc.servicecatalog.model.PublisherSummary;
import com.oracle.bmc.servicecatalog.model.UploadData;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApplicationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityId")
    private final String entityId;
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="isFeatured")
    private final Boolean isFeatured;
    @JsonProperty(value="publisher")
    private final PublisherSummary publisher;
    @JsonProperty(value="shortDescription")
    private final String shortDescription;
    @JsonProperty(value="logo")
    private final UploadData logo;
    @JsonProperty(value="pricingType")
    private final PricingTypeEnum pricingType;
    @JsonProperty(value="packageType")
    private final PackageTypeEnum packageType;

    @Deprecated
    @ConstructorProperties(value={"entityId", "entityType", "displayName", "isFeatured", "publisher", "shortDescription", "logo", "pricingType", "packageType"})
    public ApplicationSummary(String entityId, String entityType, String displayName, Boolean isFeatured, PublisherSummary publisher, String shortDescription, UploadData logo, PricingTypeEnum pricingType, PackageTypeEnum packageType) {
        this.entityId = entityId;
        this.entityType = entityType;
        this.displayName = displayName;
        this.isFeatured = isFeatured;
        this.publisher = publisher;
        this.shortDescription = shortDescription;
        this.logo = logo;
        this.pricingType = pricingType;
        this.packageType = packageType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getIsFeatured() {
        return this.isFeatured;
    }

    public PublisherSummary getPublisher() {
        return this.publisher;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public UploadData getLogo() {
        return this.logo;
    }

    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    public PackageTypeEnum getPackageType() {
        return this.packageType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplicationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("entityId=").append(String.valueOf(this.entityId));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", isFeatured=").append(String.valueOf(this.isFeatured));
        sb.append(", publisher=").append(String.valueOf((Object)this.publisher));
        sb.append(", shortDescription=").append(String.valueOf(this.shortDescription));
        sb.append(", logo=").append(String.valueOf((Object)this.logo));
        sb.append(", pricingType=").append(String.valueOf((Object)this.pricingType));
        sb.append(", packageType=").append(String.valueOf((Object)this.packageType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)((Object)o);
        return Objects.equals(this.entityId, other.entityId) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.isFeatured, other.isFeatured) && Objects.equals((Object)this.publisher, (Object)other.publisher) && Objects.equals(this.shortDescription, other.shortDescription) && Objects.equals((Object)this.logo, (Object)other.logo) && Objects.equals((Object)this.pricingType, (Object)other.pricingType) && Objects.equals((Object)this.packageType, (Object)other.packageType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.isFeatured == null ? 43 : this.isFeatured.hashCode());
        result = result * 59 + (this.publisher == null ? 43 : this.publisher.hashCode());
        result = result * 59 + (this.shortDescription == null ? 43 : this.shortDescription.hashCode());
        result = result * 59 + (this.logo == null ? 43 : this.logo.hashCode());
        result = result * 59 + (this.pricingType == null ? 43 : this.pricingType.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityId")
        private String entityId;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="isFeatured")
        private Boolean isFeatured;
        @JsonProperty(value="publisher")
        private PublisherSummary publisher;
        @JsonProperty(value="shortDescription")
        private String shortDescription;
        @JsonProperty(value="logo")
        private UploadData logo;
        @JsonProperty(value="pricingType")
        private PricingTypeEnum pricingType;
        @JsonProperty(value="packageType")
        private PackageTypeEnum packageType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.__explicitlySet__.add("entityId");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.__explicitlySet__.add("isFeatured");
            return this;
        }

        public Builder publisher(PublisherSummary publisher) {
            this.publisher = publisher;
            this.__explicitlySet__.add("publisher");
            return this;
        }

        public Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            this.__explicitlySet__.add("shortDescription");
            return this;
        }

        public Builder logo(UploadData logo) {
            this.logo = logo;
            this.__explicitlySet__.add("logo");
            return this;
        }

        public Builder pricingType(PricingTypeEnum pricingType) {
            this.pricingType = pricingType;
            this.__explicitlySet__.add("pricingType");
            return this;
        }

        public Builder packageType(PackageTypeEnum packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public ApplicationSummary build() {
            ApplicationSummary model = new ApplicationSummary(this.entityId, this.entityType, this.displayName, this.isFeatured, this.publisher, this.shortDescription, this.logo, this.pricingType, this.packageType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApplicationSummary model) {
            if (model.wasPropertyExplicitlySet("entityId")) {
                this.entityId(model.getEntityId());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("isFeatured")) {
                this.isFeatured(model.getIsFeatured());
            }
            if (model.wasPropertyExplicitlySet("publisher")) {
                this.publisher(model.getPublisher());
            }
            if (model.wasPropertyExplicitlySet("shortDescription")) {
                this.shortDescription(model.getShortDescription());
            }
            if (model.wasPropertyExplicitlySet("logo")) {
                this.logo(model.getLogo());
            }
            if (model.wasPropertyExplicitlySet("pricingType")) {
                this.pricingType(model.getPricingType());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            return this;
        }
    }
}

