/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog;

import com.oracle.bmc.servicecatalog.ServiceCatalog;
import com.oracle.bmc.servicecatalog.model.PrivateApplication;
import com.oracle.bmc.servicecatalog.model.ServiceCatalog;
import com.oracle.bmc.servicecatalog.requests.GetPrivateApplicationRequest;
import com.oracle.bmc.servicecatalog.requests.GetServiceCatalogRequest;
import com.oracle.bmc.servicecatalog.requests.GetWorkRequestRequest;
import com.oracle.bmc.servicecatalog.responses.GetPrivateApplicationResponse;
import com.oracle.bmc.servicecatalog.responses.GetServiceCatalogResponse;
import com.oracle.bmc.servicecatalog.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ServiceCatalogWaiters {
    private final ExecutorService executorService;
    private final ServiceCatalog client;

    public ServiceCatalogWaiters(ExecutorService executorService, ServiceCatalog client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetPrivateApplicationRequest, GetPrivateApplicationResponse> forPrivateApplication(GetPrivateApplicationRequest request, PrivateApplication.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPrivateApplication(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPrivateApplicationRequest, GetPrivateApplicationResponse> forPrivateApplication(GetPrivateApplicationRequest request, PrivateApplication.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPrivateApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPrivateApplicationRequest, GetPrivateApplicationResponse> forPrivateApplication(GetPrivateApplicationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PrivateApplication.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPrivateApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPrivateApplicationRequest, GetPrivateApplicationResponse> forPrivateApplication(BmcGenericWaiter waiter, GetPrivateApplicationRequest request, PrivateApplication.LifecycleState ... targetStates) {
        final HashSet<PrivateApplication.LifecycleState> targetStatesSet = new HashSet<PrivateApplication.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPrivateApplicationRequest, GetPrivateApplicationResponse>(){

            @Override
            public GetPrivateApplicationResponse apply(GetPrivateApplicationRequest request) {
                return ServiceCatalogWaiters.this.client.getPrivateApplication(request);
            }
        }, (Predicate)new Predicate<GetPrivateApplicationResponse>(){

            @Override
            public boolean test(GetPrivateApplicationResponse response) {
                return targetStatesSet.contains((Object)response.getPrivateApplication().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PrivateApplication.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetServiceCatalogRequest, GetServiceCatalogResponse> forServiceCatalog(GetServiceCatalogRequest request, ServiceCatalog.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forServiceCatalog(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetServiceCatalogRequest, GetServiceCatalogResponse> forServiceCatalog(GetServiceCatalogRequest request, ServiceCatalog.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forServiceCatalog(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetServiceCatalogRequest, GetServiceCatalogResponse> forServiceCatalog(GetServiceCatalogRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ServiceCatalog.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forServiceCatalog(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetServiceCatalogRequest, GetServiceCatalogResponse> forServiceCatalog(BmcGenericWaiter waiter, GetServiceCatalogRequest request, ServiceCatalog.LifecycleState ... targetStates) {
        final HashSet<ServiceCatalog.LifecycleState> targetStatesSet = new HashSet<ServiceCatalog.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetServiceCatalogRequest, GetServiceCatalogResponse>(){

            @Override
            public GetServiceCatalogResponse apply(GetServiceCatalogRequest request) {
                return ServiceCatalogWaiters.this.client.getServiceCatalog(request);
            }
        }, (Predicate)new Predicate<GetServiceCatalogResponse>(){

            @Override
            public boolean test(GetServiceCatalogResponse response) {
                return targetStatesSet.contains((Object)response.getServiceCatalog().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ServiceCatalog.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ServiceCatalogWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

