/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.servicecatalog.ServiceCatalog;
import com.oracle.bmc.servicecatalog.model.ApplicationSummary;
import com.oracle.bmc.servicecatalog.model.PrivateApplicationPackageSummary;
import com.oracle.bmc.servicecatalog.model.PrivateApplicationSummary;
import com.oracle.bmc.servicecatalog.model.ServiceCatalogAssociationSummary;
import com.oracle.bmc.servicecatalog.model.ServiceCatalogSummary;
import com.oracle.bmc.servicecatalog.model.WorkRequestError;
import com.oracle.bmc.servicecatalog.model.WorkRequestLogEntry;
import com.oracle.bmc.servicecatalog.model.WorkRequestSummary;
import com.oracle.bmc.servicecatalog.requests.ListApplicationsRequest;
import com.oracle.bmc.servicecatalog.requests.ListPrivateApplicationPackagesRequest;
import com.oracle.bmc.servicecatalog.requests.ListPrivateApplicationsRequest;
import com.oracle.bmc.servicecatalog.requests.ListServiceCatalogAssociationsRequest;
import com.oracle.bmc.servicecatalog.requests.ListServiceCatalogsRequest;
import com.oracle.bmc.servicecatalog.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.servicecatalog.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.servicecatalog.requests.ListWorkRequestsRequest;
import com.oracle.bmc.servicecatalog.responses.ListApplicationsResponse;
import com.oracle.bmc.servicecatalog.responses.ListPrivateApplicationPackagesResponse;
import com.oracle.bmc.servicecatalog.responses.ListPrivateApplicationsResponse;
import com.oracle.bmc.servicecatalog.responses.ListServiceCatalogAssociationsResponse;
import com.oracle.bmc.servicecatalog.responses.ListServiceCatalogsResponse;
import com.oracle.bmc.servicecatalog.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.servicecatalog.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.servicecatalog.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ServiceCatalogPaginators {
    private final ServiceCatalog client;

    public ServiceCatalogPaginators(ServiceCatalog client) {
        this.client = client;
    }

    public Iterable<ListApplicationsResponse> listApplicationsResponseIterator(final ListApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            @Override
            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            @Override
            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            @Override
            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            @Override
            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return ServiceCatalogPaginators.this.client.listApplications(request);
            }
        });
    }

    public Iterable<ApplicationSummary> listApplicationsRecordIterator(final ListApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            @Override
            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            @Override
            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            @Override
            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            @Override
            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return ServiceCatalogPaginators.this.client.listApplications(request);
            }
        }, (Function)new Function<ListApplicationsResponse, List<ApplicationSummary>>(){

            @Override
            public List<ApplicationSummary> apply(ListApplicationsResponse response) {
                return response.getApplicationCollection().getItems();
            }
        });
    }

    public Iterable<ListPrivateApplicationPackagesResponse> listPrivateApplicationPackagesResponseIterator(final ListPrivateApplicationPackagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPrivateApplicationPackagesRequest.Builder>(){

            @Override
            public ListPrivateApplicationPackagesRequest.Builder get() {
                return ListPrivateApplicationPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateApplicationPackagesResponse, String>(){

            @Override
            public String apply(ListPrivateApplicationPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateApplicationPackagesRequest.Builder>, ListPrivateApplicationPackagesRequest>(){

            @Override
            public ListPrivateApplicationPackagesRequest apply(RequestBuilderAndToken<ListPrivateApplicationPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateApplicationPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateApplicationPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateApplicationPackagesRequest, ListPrivateApplicationPackagesResponse>(){

            @Override
            public ListPrivateApplicationPackagesResponse apply(ListPrivateApplicationPackagesRequest request) {
                return ServiceCatalogPaginators.this.client.listPrivateApplicationPackages(request);
            }
        });
    }

    public Iterable<PrivateApplicationPackageSummary> listPrivateApplicationPackagesRecordIterator(final ListPrivateApplicationPackagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPrivateApplicationPackagesRequest.Builder>(){

            @Override
            public ListPrivateApplicationPackagesRequest.Builder get() {
                return ListPrivateApplicationPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateApplicationPackagesResponse, String>(){

            @Override
            public String apply(ListPrivateApplicationPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateApplicationPackagesRequest.Builder>, ListPrivateApplicationPackagesRequest>(){

            @Override
            public ListPrivateApplicationPackagesRequest apply(RequestBuilderAndToken<ListPrivateApplicationPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateApplicationPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateApplicationPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateApplicationPackagesRequest, ListPrivateApplicationPackagesResponse>(){

            @Override
            public ListPrivateApplicationPackagesResponse apply(ListPrivateApplicationPackagesRequest request) {
                return ServiceCatalogPaginators.this.client.listPrivateApplicationPackages(request);
            }
        }, (Function)new Function<ListPrivateApplicationPackagesResponse, List<PrivateApplicationPackageSummary>>(){

            @Override
            public List<PrivateApplicationPackageSummary> apply(ListPrivateApplicationPackagesResponse response) {
                return response.getPrivateApplicationPackageCollection().getItems();
            }
        });
    }

    public Iterable<ListPrivateApplicationsResponse> listPrivateApplicationsResponseIterator(final ListPrivateApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPrivateApplicationsRequest.Builder>(){

            @Override
            public ListPrivateApplicationsRequest.Builder get() {
                return ListPrivateApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateApplicationsResponse, String>(){

            @Override
            public String apply(ListPrivateApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateApplicationsRequest.Builder>, ListPrivateApplicationsRequest>(){

            @Override
            public ListPrivateApplicationsRequest apply(RequestBuilderAndToken<ListPrivateApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateApplicationsRequest, ListPrivateApplicationsResponse>(){

            @Override
            public ListPrivateApplicationsResponse apply(ListPrivateApplicationsRequest request) {
                return ServiceCatalogPaginators.this.client.listPrivateApplications(request);
            }
        });
    }

    public Iterable<PrivateApplicationSummary> listPrivateApplicationsRecordIterator(final ListPrivateApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPrivateApplicationsRequest.Builder>(){

            @Override
            public ListPrivateApplicationsRequest.Builder get() {
                return ListPrivateApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateApplicationsResponse, String>(){

            @Override
            public String apply(ListPrivateApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateApplicationsRequest.Builder>, ListPrivateApplicationsRequest>(){

            @Override
            public ListPrivateApplicationsRequest apply(RequestBuilderAndToken<ListPrivateApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateApplicationsRequest, ListPrivateApplicationsResponse>(){

            @Override
            public ListPrivateApplicationsResponse apply(ListPrivateApplicationsRequest request) {
                return ServiceCatalogPaginators.this.client.listPrivateApplications(request);
            }
        }, (Function)new Function<ListPrivateApplicationsResponse, List<PrivateApplicationSummary>>(){

            @Override
            public List<PrivateApplicationSummary> apply(ListPrivateApplicationsResponse response) {
                return response.getPrivateApplicationCollection().getItems();
            }
        });
    }

    public Iterable<ListServiceCatalogAssociationsResponse> listServiceCatalogAssociationsResponseIterator(final ListServiceCatalogAssociationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListServiceCatalogAssociationsRequest.Builder>(){

            @Override
            public ListServiceCatalogAssociationsRequest.Builder get() {
                return ListServiceCatalogAssociationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServiceCatalogAssociationsResponse, String>(){

            @Override
            public String apply(ListServiceCatalogAssociationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServiceCatalogAssociationsRequest.Builder>, ListServiceCatalogAssociationsRequest>(){

            @Override
            public ListServiceCatalogAssociationsRequest apply(RequestBuilderAndToken<ListServiceCatalogAssociationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServiceCatalogAssociationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServiceCatalogAssociationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServiceCatalogAssociationsRequest, ListServiceCatalogAssociationsResponse>(){

            @Override
            public ListServiceCatalogAssociationsResponse apply(ListServiceCatalogAssociationsRequest request) {
                return ServiceCatalogPaginators.this.client.listServiceCatalogAssociations(request);
            }
        });
    }

    public Iterable<ServiceCatalogAssociationSummary> listServiceCatalogAssociationsRecordIterator(final ListServiceCatalogAssociationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListServiceCatalogAssociationsRequest.Builder>(){

            @Override
            public ListServiceCatalogAssociationsRequest.Builder get() {
                return ListServiceCatalogAssociationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServiceCatalogAssociationsResponse, String>(){

            @Override
            public String apply(ListServiceCatalogAssociationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServiceCatalogAssociationsRequest.Builder>, ListServiceCatalogAssociationsRequest>(){

            @Override
            public ListServiceCatalogAssociationsRequest apply(RequestBuilderAndToken<ListServiceCatalogAssociationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServiceCatalogAssociationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServiceCatalogAssociationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServiceCatalogAssociationsRequest, ListServiceCatalogAssociationsResponse>(){

            @Override
            public ListServiceCatalogAssociationsResponse apply(ListServiceCatalogAssociationsRequest request) {
                return ServiceCatalogPaginators.this.client.listServiceCatalogAssociations(request);
            }
        }, (Function)new Function<ListServiceCatalogAssociationsResponse, List<ServiceCatalogAssociationSummary>>(){

            @Override
            public List<ServiceCatalogAssociationSummary> apply(ListServiceCatalogAssociationsResponse response) {
                return response.getServiceCatalogAssociationCollection().getItems();
            }
        });
    }

    public Iterable<ListServiceCatalogsResponse> listServiceCatalogsResponseIterator(final ListServiceCatalogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListServiceCatalogsRequest.Builder>(){

            @Override
            public ListServiceCatalogsRequest.Builder get() {
                return ListServiceCatalogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServiceCatalogsResponse, String>(){

            @Override
            public String apply(ListServiceCatalogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServiceCatalogsRequest.Builder>, ListServiceCatalogsRequest>(){

            @Override
            public ListServiceCatalogsRequest apply(RequestBuilderAndToken<ListServiceCatalogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServiceCatalogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServiceCatalogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServiceCatalogsRequest, ListServiceCatalogsResponse>(){

            @Override
            public ListServiceCatalogsResponse apply(ListServiceCatalogsRequest request) {
                return ServiceCatalogPaginators.this.client.listServiceCatalogs(request);
            }
        });
    }

    public Iterable<ServiceCatalogSummary> listServiceCatalogsRecordIterator(final ListServiceCatalogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListServiceCatalogsRequest.Builder>(){

            @Override
            public ListServiceCatalogsRequest.Builder get() {
                return ListServiceCatalogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServiceCatalogsResponse, String>(){

            @Override
            public String apply(ListServiceCatalogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServiceCatalogsRequest.Builder>, ListServiceCatalogsRequest>(){

            @Override
            public ListServiceCatalogsRequest apply(RequestBuilderAndToken<ListServiceCatalogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServiceCatalogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServiceCatalogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServiceCatalogsRequest, ListServiceCatalogsResponse>(){

            @Override
            public ListServiceCatalogsResponse apply(ListServiceCatalogsRequest request) {
                return ServiceCatalogPaginators.this.client.listServiceCatalogs(request);
            }
        }, (Function)new Function<ListServiceCatalogsResponse, List<ServiceCatalogSummary>>(){

            @Override
            public List<ServiceCatalogSummary> apply(ListServiceCatalogsResponse response) {
                return response.getServiceCatalogCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ServiceCatalogPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ServiceCatalogPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ServiceCatalogPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ServiceCatalogPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ServiceCatalogPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ServiceCatalogPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

