/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicecatalog;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.servicecatalog.ServiceCatalogAsync;
import com.oracle.bmc.servicecatalog.model.ApplicationCollection;
import com.oracle.bmc.servicecatalog.model.PrivateApplication;
import com.oracle.bmc.servicecatalog.model.PrivateApplicationCollection;
import com.oracle.bmc.servicecatalog.model.PrivateApplicationPackage;
import com.oracle.bmc.servicecatalog.model.PrivateApplicationPackageCollection;
import com.oracle.bmc.servicecatalog.model.ServiceCatalog;
import com.oracle.bmc.servicecatalog.model.ServiceCatalogAssociation;
import com.oracle.bmc.servicecatalog.model.ServiceCatalogAssociationCollection;
import com.oracle.bmc.servicecatalog.model.ServiceCatalogCollection;
import com.oracle.bmc.servicecatalog.model.WorkRequest;
import com.oracle.bmc.servicecatalog.model.WorkRequestErrorCollection;
import com.oracle.bmc.servicecatalog.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.servicecatalog.model.WorkRequestSummaryCollection;
import com.oracle.bmc.servicecatalog.requests.BulkReplaceServiceCatalogAssociationsRequest;
import com.oracle.bmc.servicecatalog.requests.ChangePrivateApplicationCompartmentRequest;
import com.oracle.bmc.servicecatalog.requests.ChangeServiceCatalogCompartmentRequest;
import com.oracle.bmc.servicecatalog.requests.CreatePrivateApplicationRequest;
import com.oracle.bmc.servicecatalog.requests.CreateServiceCatalogAssociationRequest;
import com.oracle.bmc.servicecatalog.requests.CreateServiceCatalogRequest;
import com.oracle.bmc.servicecatalog.requests.DeletePrivateApplicationRequest;
import com.oracle.bmc.servicecatalog.requests.DeleteServiceCatalogAssociationRequest;
import com.oracle.bmc.servicecatalog.requests.DeleteServiceCatalogRequest;
import com.oracle.bmc.servicecatalog.requests.GetPrivateApplicationActionDownloadLogoRequest;
import com.oracle.bmc.servicecatalog.requests.GetPrivateApplicationPackageActionDownloadConfigRequest;
import com.oracle.bmc.servicecatalog.requests.GetPrivateApplicationPackageRequest;
import com.oracle.bmc.servicecatalog.requests.GetPrivateApplicationRequest;
import com.oracle.bmc.servicecatalog.requests.GetServiceCatalogAssociationRequest;
import com.oracle.bmc.servicecatalog.requests.GetServiceCatalogRequest;
import com.oracle.bmc.servicecatalog.requests.GetWorkRequestRequest;
import com.oracle.bmc.servicecatalog.requests.ListApplicationsRequest;
import com.oracle.bmc.servicecatalog.requests.ListPrivateApplicationPackagesRequest;
import com.oracle.bmc.servicecatalog.requests.ListPrivateApplicationsRequest;
import com.oracle.bmc.servicecatalog.requests.ListServiceCatalogAssociationsRequest;
import com.oracle.bmc.servicecatalog.requests.ListServiceCatalogsRequest;
import com.oracle.bmc.servicecatalog.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.servicecatalog.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.servicecatalog.requests.ListWorkRequestsRequest;
import com.oracle.bmc.servicecatalog.requests.UpdatePrivateApplicationRequest;
import com.oracle.bmc.servicecatalog.requests.UpdateServiceCatalogRequest;
import com.oracle.bmc.servicecatalog.responses.BulkReplaceServiceCatalogAssociationsResponse;
import com.oracle.bmc.servicecatalog.responses.ChangePrivateApplicationCompartmentResponse;
import com.oracle.bmc.servicecatalog.responses.ChangeServiceCatalogCompartmentResponse;
import com.oracle.bmc.servicecatalog.responses.CreatePrivateApplicationResponse;
import com.oracle.bmc.servicecatalog.responses.CreateServiceCatalogAssociationResponse;
import com.oracle.bmc.servicecatalog.responses.CreateServiceCatalogResponse;
import com.oracle.bmc.servicecatalog.responses.DeletePrivateApplicationResponse;
import com.oracle.bmc.servicecatalog.responses.DeleteServiceCatalogAssociationResponse;
import com.oracle.bmc.servicecatalog.responses.DeleteServiceCatalogResponse;
import com.oracle.bmc.servicecatalog.responses.GetPrivateApplicationActionDownloadLogoResponse;
import com.oracle.bmc.servicecatalog.responses.GetPrivateApplicationPackageActionDownloadConfigResponse;
import com.oracle.bmc.servicecatalog.responses.GetPrivateApplicationPackageResponse;
import com.oracle.bmc.servicecatalog.responses.GetPrivateApplicationResponse;
import com.oracle.bmc.servicecatalog.responses.GetServiceCatalogAssociationResponse;
import com.oracle.bmc.servicecatalog.responses.GetServiceCatalogResponse;
import com.oracle.bmc.servicecatalog.responses.GetWorkRequestResponse;
import com.oracle.bmc.servicecatalog.responses.ListApplicationsResponse;
import com.oracle.bmc.servicecatalog.responses.ListPrivateApplicationPackagesResponse;
import com.oracle.bmc.servicecatalog.responses.ListPrivateApplicationsResponse;
import com.oracle.bmc.servicecatalog.responses.ListServiceCatalogAssociationsResponse;
import com.oracle.bmc.servicecatalog.responses.ListServiceCatalogsResponse;
import com.oracle.bmc.servicecatalog.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.servicecatalog.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.servicecatalog.responses.ListWorkRequestsResponse;
import com.oracle.bmc.servicecatalog.responses.UpdatePrivateApplicationResponse;
import com.oracle.bmc.servicecatalog.responses.UpdateServiceCatalogResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCatalogAsyncClient
extends BaseAsyncClient
implements ServiceCatalogAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SERVICECATALOG").serviceEndpointPrefix("").serviceEndpointTemplate("https://service-catalog.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCatalogAsyncClient.class);

    private ServiceCatalogAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<BulkReplaceServiceCatalogAssociationsResponse> bulkReplaceServiceCatalogAssociations(BulkReplaceServiceCatalogAssociationsRequest request, AsyncHandler<BulkReplaceServiceCatalogAssociationsRequest, BulkReplaceServiceCatalogAssociationsResponse> handler) {
        Validate.notBlank((String)request.getServiceCatalogId(), (String)"serviceCatalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBulkReplaceServiceCatalogAssociationsDetails(), "bulkReplaceServiceCatalogAssociationsDetails is required");
        return this.clientCall(request, BulkReplaceServiceCatalogAssociationsResponse::builder).logger(LOG, "bulkReplaceServiceCatalogAssociations").serviceDetails("ServiceCatalog", "BulkReplaceServiceCatalogAssociations", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalogAssociation/BulkReplaceServiceCatalogAssociations").method(Method.PUT).requestBuilder(BulkReplaceServiceCatalogAssociationsRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogs").appendPathParam(request.getServiceCatalogId()).appendPathParam("actions").appendPathParam("bulkReplaceAssociations").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", BulkReplaceServiceCatalogAssociationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangePrivateApplicationCompartmentResponse> changePrivateApplicationCompartment(ChangePrivateApplicationCompartmentRequest request, AsyncHandler<ChangePrivateApplicationCompartmentRequest, ChangePrivateApplicationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getPrivateApplicationId(), (String)"privateApplicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePrivateApplicationCompartmentDetails(), "changePrivateApplicationCompartmentDetails is required");
        return this.clientCall(request, ChangePrivateApplicationCompartmentResponse::builder).logger(LOG, "changePrivateApplicationCompartment").serviceDetails("ServiceCatalog", "ChangePrivateApplicationCompartment", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplication/ChangePrivateApplicationCompartment").method(Method.POST).requestBuilder(ChangePrivateApplicationCompartmentRequest::builder).basePath("/20210527").appendPathParam("privateApplications").appendPathParam(request.getPrivateApplicationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangePrivateApplicationCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangePrivateApplicationCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeServiceCatalogCompartmentResponse> changeServiceCatalogCompartment(ChangeServiceCatalogCompartmentRequest request, AsyncHandler<ChangeServiceCatalogCompartmentRequest, ChangeServiceCatalogCompartmentResponse> handler) {
        Validate.notBlank((String)request.getServiceCatalogId(), (String)"serviceCatalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeServiceCatalogCompartmentDetails(), "changeServiceCatalogCompartmentDetails is required");
        return this.clientCall(request, ChangeServiceCatalogCompartmentResponse::builder).logger(LOG, "changeServiceCatalogCompartment").serviceDetails("ServiceCatalog", "ChangeServiceCatalogCompartment", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalog/ChangeServiceCatalogCompartment").method(Method.POST).requestBuilder(ChangeServiceCatalogCompartmentRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogs").appendPathParam(request.getServiceCatalogId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeServiceCatalogCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePrivateApplicationResponse> createPrivateApplication(CreatePrivateApplicationRequest request, AsyncHandler<CreatePrivateApplicationRequest, CreatePrivateApplicationResponse> handler) {
        Objects.requireNonNull(request.getCreatePrivateApplicationDetails(), "createPrivateApplicationDetails is required");
        return this.clientCall(request, CreatePrivateApplicationResponse::builder).logger(LOG, "createPrivateApplication").serviceDetails("ServiceCatalog", "CreatePrivateApplication", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplication/CreatePrivateApplication").method(Method.POST).requestBuilder(CreatePrivateApplicationRequest::builder).basePath("/20210527").appendPathParam("privateApplications").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PrivateApplication.class, CreatePrivateApplicationResponse.Builder::privateApplication).handleResponseHeaderString("opc-request-id", CreatePrivateApplicationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreatePrivateApplicationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreatePrivateApplicationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateServiceCatalogResponse> createServiceCatalog(CreateServiceCatalogRequest request, AsyncHandler<CreateServiceCatalogRequest, CreateServiceCatalogResponse> handler) {
        Objects.requireNonNull(request.getCreateServiceCatalogDetails(), "createServiceCatalogDetails is required");
        return this.clientCall(request, CreateServiceCatalogResponse::builder).logger(LOG, "createServiceCatalog").serviceDetails("ServiceCatalog", "CreateServiceCatalog", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalog/CreateServiceCatalog").method(Method.POST).requestBuilder(CreateServiceCatalogRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ServiceCatalog.class, CreateServiceCatalogResponse.Builder::serviceCatalog).handleResponseHeaderString("opc-request-id", CreateServiceCatalogResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateServiceCatalogResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateServiceCatalogAssociationResponse> createServiceCatalogAssociation(CreateServiceCatalogAssociationRequest request, AsyncHandler<CreateServiceCatalogAssociationRequest, CreateServiceCatalogAssociationResponse> handler) {
        Objects.requireNonNull(request.getCreateServiceCatalogAssociationDetails(), "createServiceCatalogAssociationDetails is required");
        return this.clientCall(request, CreateServiceCatalogAssociationResponse::builder).logger(LOG, "createServiceCatalogAssociation").serviceDetails("ServiceCatalog", "CreateServiceCatalogAssociation", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalogAssociation/CreateServiceCatalogAssociation").method(Method.POST).requestBuilder(CreateServiceCatalogAssociationRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogAssociations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ServiceCatalogAssociation.class, CreateServiceCatalogAssociationResponse.Builder::serviceCatalogAssociation).handleResponseHeaderString("opc-request-id", CreateServiceCatalogAssociationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateServiceCatalogAssociationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeletePrivateApplicationResponse> deletePrivateApplication(DeletePrivateApplicationRequest request, AsyncHandler<DeletePrivateApplicationRequest, DeletePrivateApplicationResponse> handler) {
        Validate.notBlank((String)request.getPrivateApplicationId(), (String)"privateApplicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePrivateApplicationResponse::builder).logger(LOG, "deletePrivateApplication").serviceDetails("ServiceCatalog", "DeletePrivateApplication", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplication/DeletePrivateApplication").method(Method.DELETE).requestBuilder(DeletePrivateApplicationRequest::builder).basePath("/20210527").appendPathParam("privateApplications").appendPathParam(request.getPrivateApplicationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePrivateApplicationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeletePrivateApplicationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteServiceCatalogResponse> deleteServiceCatalog(DeleteServiceCatalogRequest request, AsyncHandler<DeleteServiceCatalogRequest, DeleteServiceCatalogResponse> handler) {
        Validate.notBlank((String)request.getServiceCatalogId(), (String)"serviceCatalogId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteServiceCatalogResponse::builder).logger(LOG, "deleteServiceCatalog").serviceDetails("ServiceCatalog", "DeleteServiceCatalog", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalog/DeleteServiceCatalog").method(Method.DELETE).requestBuilder(DeleteServiceCatalogRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogs").appendPathParam(request.getServiceCatalogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteServiceCatalogResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteServiceCatalogAssociationResponse> deleteServiceCatalogAssociation(DeleteServiceCatalogAssociationRequest request, AsyncHandler<DeleteServiceCatalogAssociationRequest, DeleteServiceCatalogAssociationResponse> handler) {
        Validate.notBlank((String)request.getServiceCatalogAssociationId(), (String)"serviceCatalogAssociationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteServiceCatalogAssociationResponse::builder).logger(LOG, "deleteServiceCatalogAssociation").serviceDetails("ServiceCatalog", "DeleteServiceCatalogAssociation", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalogAssociation/DeleteServiceCatalogAssociation").method(Method.DELETE).requestBuilder(DeleteServiceCatalogAssociationRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogAssociations").appendPathParam(request.getServiceCatalogAssociationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteServiceCatalogAssociationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPrivateApplicationResponse> getPrivateApplication(GetPrivateApplicationRequest request, AsyncHandler<GetPrivateApplicationRequest, GetPrivateApplicationResponse> handler) {
        Validate.notBlank((String)request.getPrivateApplicationId(), (String)"privateApplicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPrivateApplicationResponse::builder).logger(LOG, "getPrivateApplication").serviceDetails("ServiceCatalog", "GetPrivateApplication", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplication/GetPrivateApplication").method(Method.GET).requestBuilder(GetPrivateApplicationRequest::builder).basePath("/20210527").appendPathParam("privateApplications").appendPathParam(request.getPrivateApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateApplication.class, GetPrivateApplicationResponse.Builder::privateApplication).handleResponseHeaderString("etag", GetPrivateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPrivateApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPrivateApplicationActionDownloadLogoResponse> getPrivateApplicationActionDownloadLogo(GetPrivateApplicationActionDownloadLogoRequest request, AsyncHandler<GetPrivateApplicationActionDownloadLogoRequest, GetPrivateApplicationActionDownloadLogoResponse> handler) {
        Validate.notBlank((String)request.getPrivateApplicationId(), (String)"privateApplicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPrivateApplicationActionDownloadLogoResponse::builder).logger(LOG, "getPrivateApplicationActionDownloadLogo").serviceDetails("ServiceCatalog", "GetPrivateApplicationActionDownloadLogo", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplication/GetPrivateApplicationActionDownloadLogo").method(Method.GET).requestBuilder(GetPrivateApplicationActionDownloadLogoRequest::builder).basePath("/20210527").appendPathParam("privateApplications").appendPathParam(request.getPrivateApplicationId()).appendPathParam("actions").appendPathParam("downloadLogo").accept(new String[]{"image/bmp", "image/gif", "image/jpeg", "image/png", "image/tiff"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetPrivateApplicationActionDownloadLogoResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetPrivateApplicationActionDownloadLogoResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPrivateApplicationPackageResponse> getPrivateApplicationPackage(GetPrivateApplicationPackageRequest request, AsyncHandler<GetPrivateApplicationPackageRequest, GetPrivateApplicationPackageResponse> handler) {
        Validate.notBlank((String)request.getPrivateApplicationPackageId(), (String)"privateApplicationPackageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPrivateApplicationPackageResponse::builder).logger(LOG, "getPrivateApplicationPackage").serviceDetails("ServiceCatalog", "GetPrivateApplicationPackage", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplicationPackage/GetPrivateApplicationPackage").method(Method.GET).requestBuilder(GetPrivateApplicationPackageRequest::builder).basePath("/20210527").appendPathParam("privateApplicationPackages").appendPathParam(request.getPrivateApplicationPackageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateApplicationPackage.class, GetPrivateApplicationPackageResponse.Builder::privateApplicationPackage).handleResponseHeaderString("etag", GetPrivateApplicationPackageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPrivateApplicationPackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPrivateApplicationPackageActionDownloadConfigResponse> getPrivateApplicationPackageActionDownloadConfig(GetPrivateApplicationPackageActionDownloadConfigRequest request, AsyncHandler<GetPrivateApplicationPackageActionDownloadConfigRequest, GetPrivateApplicationPackageActionDownloadConfigResponse> handler) {
        Validate.notBlank((String)request.getPrivateApplicationPackageId(), (String)"privateApplicationPackageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPrivateApplicationPackageActionDownloadConfigResponse::builder).logger(LOG, "getPrivateApplicationPackageActionDownloadConfig").serviceDetails("ServiceCatalog", "GetPrivateApplicationPackageActionDownloadConfig", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplicationPackage/GetPrivateApplicationPackageActionDownloadConfig").method(Method.GET).requestBuilder(GetPrivateApplicationPackageActionDownloadConfigRequest::builder).basePath("/20210527").appendPathParam("privateApplicationPackages").appendPathParam(request.getPrivateApplicationPackageId()).appendPathParam("actions").appendPathParam("downloadConfig").accept(new String[]{"application/zip"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetPrivateApplicationPackageActionDownloadConfigResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetPrivateApplicationPackageActionDownloadConfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetServiceCatalogResponse> getServiceCatalog(GetServiceCatalogRequest request, AsyncHandler<GetServiceCatalogRequest, GetServiceCatalogResponse> handler) {
        Validate.notBlank((String)request.getServiceCatalogId(), (String)"serviceCatalogId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetServiceCatalogResponse::builder).logger(LOG, "getServiceCatalog").serviceDetails("ServiceCatalog", "GetServiceCatalog", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalog/GetServiceCatalog").method(Method.GET).requestBuilder(GetServiceCatalogRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogs").appendPathParam(request.getServiceCatalogId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceCatalog.class, GetServiceCatalogResponse.Builder::serviceCatalog).handleResponseHeaderString("opc-request-id", GetServiceCatalogResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetServiceCatalogResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetServiceCatalogAssociationResponse> getServiceCatalogAssociation(GetServiceCatalogAssociationRequest request, AsyncHandler<GetServiceCatalogAssociationRequest, GetServiceCatalogAssociationResponse> handler) {
        Validate.notBlank((String)request.getServiceCatalogAssociationId(), (String)"serviceCatalogAssociationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetServiceCatalogAssociationResponse::builder).logger(LOG, "getServiceCatalogAssociation").serviceDetails("ServiceCatalog", "GetServiceCatalogAssociation", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalogAssociation/GetServiceCatalogAssociation").method(Method.GET).requestBuilder(GetServiceCatalogAssociationRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogAssociations").appendPathParam(request.getServiceCatalogAssociationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceCatalogAssociation.class, GetServiceCatalogAssociationResponse.Builder::serviceCatalogAssociation).handleResponseHeaderString("opc-request-id", GetServiceCatalogAssociationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetServiceCatalogAssociationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ServiceCatalog", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210527").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListApplicationsResponse> listApplications(ListApplicationsRequest request, AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handler) {
        return this.clientCall(request, ListApplicationsResponse::builder).logger(LOG, "listApplications").serviceDetails("ServiceCatalog", "ListApplications", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ApplicationSummary/ListApplications").method(Method.GET).requestBuilder(ListApplicationsRequest::builder).basePath("/20210527").appendPathParam("applications").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("serviceCatalogId", (Object)request.getServiceCatalogId()).appendQueryParam("entityType", (Object)request.getEntityType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("entityId", (Object)request.getEntityId()).appendListQueryParam("publisherId", request.getPublisherId(), CollectionFormatType.Multi).appendListQueryParam("packageType", request.getPackageType(), CollectionFormatType.Multi).appendListQueryParam("pricing", request.getPricing(), CollectionFormatType.Multi).appendQueryParam("isFeatured", (Object)request.getIsFeatured()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApplicationCollection.class, ListApplicationsResponse.Builder::applicationCollection).handleResponseHeaderString("opc-request-id", ListApplicationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApplicationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPrivateApplicationPackagesResponse> listPrivateApplicationPackages(ListPrivateApplicationPackagesRequest request, AsyncHandler<ListPrivateApplicationPackagesRequest, ListPrivateApplicationPackagesResponse> handler) {
        Objects.requireNonNull(request.getPrivateApplicationId(), "privateApplicationId is required");
        return this.clientCall(request, ListPrivateApplicationPackagesResponse::builder).logger(LOG, "listPrivateApplicationPackages").serviceDetails("ServiceCatalog", "ListPrivateApplicationPackages", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplicationPackage/ListPrivateApplicationPackages").method(Method.GET).requestBuilder(ListPrivateApplicationPackagesRequest::builder).basePath("/20210527").appendPathParam("privateApplicationPackages").appendQueryParam("privateApplicationId", (Object)request.getPrivateApplicationId()).appendQueryParam("privateApplicationPackageId", (Object)request.getPrivateApplicationPackageId()).appendListQueryParam("packageType", request.getPackageType(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateApplicationPackageCollection.class, ListPrivateApplicationPackagesResponse.Builder::privateApplicationPackageCollection).handleResponseHeaderString("opc-request-id", ListPrivateApplicationPackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPrivateApplicationPackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPrivateApplicationsResponse> listPrivateApplications(ListPrivateApplicationsRequest request, AsyncHandler<ListPrivateApplicationsRequest, ListPrivateApplicationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListPrivateApplicationsResponse::builder).logger(LOG, "listPrivateApplications").serviceDetails("ServiceCatalog", "ListPrivateApplications", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplication/ListPrivateApplications").method(Method.GET).requestBuilder(ListPrivateApplicationsRequest::builder).basePath("/20210527").appendPathParam("privateApplications").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("privateApplicationId", (Object)request.getPrivateApplicationId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateApplicationCollection.class, ListPrivateApplicationsResponse.Builder::privateApplicationCollection).handleResponseHeaderString("opc-request-id", ListPrivateApplicationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPrivateApplicationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListServiceCatalogAssociationsResponse> listServiceCatalogAssociations(ListServiceCatalogAssociationsRequest request, AsyncHandler<ListServiceCatalogAssociationsRequest, ListServiceCatalogAssociationsResponse> handler) {
        return this.clientCall(request, ListServiceCatalogAssociationsResponse::builder).logger(LOG, "listServiceCatalogAssociations").serviceDetails("ServiceCatalog", "ListServiceCatalogAssociations", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalogAssociation/ListServiceCatalogAssociations").method(Method.GET).requestBuilder(ListServiceCatalogAssociationsRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogAssociations").appendQueryParam("serviceCatalogAssociationId", (Object)request.getServiceCatalogAssociationId()).appendQueryParam("serviceCatalogId", (Object)request.getServiceCatalogId()).appendQueryParam("entityId", (Object)request.getEntityId()).appendQueryParam("entityType", (Object)request.getEntityType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceCatalogAssociationCollection.class, ListServiceCatalogAssociationsResponse.Builder::serviceCatalogAssociationCollection).handleResponseHeaderString("opc-request-id", ListServiceCatalogAssociationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListServiceCatalogAssociationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListServiceCatalogsResponse> listServiceCatalogs(ListServiceCatalogsRequest request, AsyncHandler<ListServiceCatalogsRequest, ListServiceCatalogsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListServiceCatalogsResponse::builder).logger(LOG, "listServiceCatalogs").serviceDetails("ServiceCatalog", "ListServiceCatalogs", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalog/ListServiceCatalogs").method(Method.GET).requestBuilder(ListServiceCatalogsRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("serviceCatalogId", (Object)request.getServiceCatalogId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceCatalogCollection.class, ListServiceCatalogsResponse.Builder::serviceCatalogCollection).handleResponseHeaderString("opc-request-id", ListServiceCatalogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListServiceCatalogsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ServiceCatalog", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210527").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ServiceCatalog", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210527").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ServiceCatalog", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210527").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdatePrivateApplicationResponse> updatePrivateApplication(UpdatePrivateApplicationRequest request, AsyncHandler<UpdatePrivateApplicationRequest, UpdatePrivateApplicationResponse> handler) {
        Validate.notBlank((String)request.getPrivateApplicationId(), (String)"privateApplicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePrivateApplicationDetails(), "updatePrivateApplicationDetails is required");
        return this.clientCall(request, UpdatePrivateApplicationResponse::builder).logger(LOG, "updatePrivateApplication").serviceDetails("ServiceCatalog", "UpdatePrivateApplication", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/PrivateApplication/UpdatePrivateApplication").method(Method.PUT).requestBuilder(UpdatePrivateApplicationRequest::builder).basePath("/20210527").appendPathParam("privateApplications").appendPathParam(request.getPrivateApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PrivateApplication.class, UpdatePrivateApplicationResponse.Builder::privateApplication).handleResponseHeaderString("opc-request-id", UpdatePrivateApplicationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePrivateApplicationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", UpdatePrivateApplicationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateServiceCatalogResponse> updateServiceCatalog(UpdateServiceCatalogRequest request, AsyncHandler<UpdateServiceCatalogRequest, UpdateServiceCatalogResponse> handler) {
        Validate.notBlank((String)request.getServiceCatalogId(), (String)"serviceCatalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateServiceCatalogDetails(), "updateServiceCatalogDetails is required");
        return this.clientCall(request, UpdateServiceCatalogResponse::builder).logger(LOG, "updateServiceCatalog").serviceDetails("ServiceCatalog", "UpdateServiceCatalog", "https://docs.oracle.com/iaas/api/#/en/service-catalog/20210527/ServiceCatalog/UpdateServiceCatalog").method(Method.PUT).requestBuilder(UpdateServiceCatalogRequest::builder).basePath("/20210527").appendPathParam("serviceCatalogs").appendPathParam(request.getServiceCatalogId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ServiceCatalog.class, UpdateServiceCatalogResponse.Builder::serviceCatalog).handleResponseHeaderString("opc-request-id", UpdateServiceCatalogResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateServiceCatalogResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public ServiceCatalogAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ServiceCatalogAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceCatalogAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ServiceCatalogAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceCatalogAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ServiceCatalogAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ServiceCatalogAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ServiceCatalogAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ServiceCatalogAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ServiceCatalogAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ServiceCatalogAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ServiceCatalogAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ServiceCatalogAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

