/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets.responses;

import com.oracle.bmc.secrets.model.SecretBundleVersionSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListSecretBundleVersionsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<SecretBundleVersionSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListSecretBundleVersionsResponse(String opcRequestId, String opcNextPage, List<SecretBundleVersionSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<SecretBundleVersionSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<SecretBundleVersionSummary> items;

        public Builder copy(ListSecretBundleVersionsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<SecretBundleVersionSummary> items) {
            this.items = items;
            return this;
        }

        public ListSecretBundleVersionsResponse build() {
            return new ListSecretBundleVersionsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListSecretBundleVersionsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

