/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ShapeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="gpuDescription")
    private final String gpuDescription;
    @JsonProperty(value="gpus")
    private final Integer gpus;
    @JsonProperty(value="memoryInGBs")
    private final Float memoryInGBs;
    @JsonProperty(value="networkingBandwidthInGbps")
    private final Float networkingBandwidthInGbps;
    @JsonProperty(value="ocpus")
    private final Integer ocpus;
    @JsonProperty(value="processorDescription")
    private final String processorDescription;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="usbControllerDescription")
    private final String usbControllerDescription;
    @JsonProperty(value="numberOfUsbControllers")
    private final Integer numberOfUsbControllers;
    @JsonProperty(value="tags")
    private final String tags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"gpuDescription", "gpus", "memoryInGBs", "networkingBandwidthInGbps", "ocpus", "processorDescription", "shape", "usbControllerDescription", "numberOfUsbControllers", "tags", "freeformTags", "definedTags", "systemTags"})
    public ShapeSummary(String gpuDescription, Integer gpus, Float memoryInGBs, Float networkingBandwidthInGbps, Integer ocpus, String processorDescription, String shape, String usbControllerDescription, Integer numberOfUsbControllers, String tags, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.gpuDescription = gpuDescription;
        this.gpus = gpus;
        this.memoryInGBs = memoryInGBs;
        this.networkingBandwidthInGbps = networkingBandwidthInGbps;
        this.ocpus = ocpus;
        this.processorDescription = processorDescription;
        this.shape = shape;
        this.usbControllerDescription = usbControllerDescription;
        this.numberOfUsbControllers = numberOfUsbControllers;
        this.tags = tags;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getGpuDescription() {
        return this.gpuDescription;
    }

    public Integer getGpus() {
        return this.gpus;
    }

    public Float getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public Float getNetworkingBandwidthInGbps() {
        return this.networkingBandwidthInGbps;
    }

    public Integer getOcpus() {
        return this.ocpus;
    }

    public String getProcessorDescription() {
        return this.processorDescription;
    }

    public String getShape() {
        return this.shape;
    }

    public String getUsbControllerDescription() {
        return this.usbControllerDescription;
    }

    public Integer getNumberOfUsbControllers() {
        return this.numberOfUsbControllers;
    }

    public String getTags() {
        return this.tags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShapeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("gpuDescription=").append(String.valueOf(this.gpuDescription));
        sb.append(", gpus=").append(String.valueOf(this.gpus));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", networkingBandwidthInGbps=").append(String.valueOf(this.networkingBandwidthInGbps));
        sb.append(", ocpus=").append(String.valueOf(this.ocpus));
        sb.append(", processorDescription=").append(String.valueOf(this.processorDescription));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", usbControllerDescription=").append(String.valueOf(this.usbControllerDescription));
        sb.append(", numberOfUsbControllers=").append(String.valueOf(this.numberOfUsbControllers));
        sb.append(", tags=").append(String.valueOf(this.tags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeSummary)) {
            return false;
        }
        ShapeSummary other = (ShapeSummary)((Object)o);
        return Objects.equals(this.gpuDescription, other.gpuDescription) && Objects.equals(this.gpus, other.gpus) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals(this.networkingBandwidthInGbps, other.networkingBandwidthInGbps) && Objects.equals(this.ocpus, other.ocpus) && Objects.equals(this.processorDescription, other.processorDescription) && Objects.equals(this.shape, other.shape) && Objects.equals(this.usbControllerDescription, other.usbControllerDescription) && Objects.equals(this.numberOfUsbControllers, other.numberOfUsbControllers) && Objects.equals(this.tags, other.tags) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.gpuDescription == null ? 43 : this.gpuDescription.hashCode());
        result = result * 59 + (this.gpus == null ? 43 : this.gpus.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.networkingBandwidthInGbps == null ? 43 : this.networkingBandwidthInGbps.hashCode());
        result = result * 59 + (this.ocpus == null ? 43 : this.ocpus.hashCode());
        result = result * 59 + (this.processorDescription == null ? 43 : this.processorDescription.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.usbControllerDescription == null ? 43 : this.usbControllerDescription.hashCode());
        result = result * 59 + (this.numberOfUsbControllers == null ? 43 : this.numberOfUsbControllers.hashCode());
        result = result * 59 + (this.tags == null ? 43 : this.tags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="gpuDescription")
        private String gpuDescription;
        @JsonProperty(value="gpus")
        private Integer gpus;
        @JsonProperty(value="memoryInGBs")
        private Float memoryInGBs;
        @JsonProperty(value="networkingBandwidthInGbps")
        private Float networkingBandwidthInGbps;
        @JsonProperty(value="ocpus")
        private Integer ocpus;
        @JsonProperty(value="processorDescription")
        private String processorDescription;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="usbControllerDescription")
        private String usbControllerDescription;
        @JsonProperty(value="numberOfUsbControllers")
        private Integer numberOfUsbControllers;
        @JsonProperty(value="tags")
        private String tags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder gpuDescription(String gpuDescription) {
            this.gpuDescription = gpuDescription;
            this.__explicitlySet__.add("gpuDescription");
            return this;
        }

        public Builder gpus(Integer gpus) {
            this.gpus = gpus;
            this.__explicitlySet__.add("gpus");
            return this;
        }

        public Builder memoryInGBs(Float memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder networkingBandwidthInGbps(Float networkingBandwidthInGbps) {
            this.networkingBandwidthInGbps = networkingBandwidthInGbps;
            this.__explicitlySet__.add("networkingBandwidthInGbps");
            return this;
        }

        public Builder ocpus(Integer ocpus) {
            this.ocpus = ocpus;
            this.__explicitlySet__.add("ocpus");
            return this;
        }

        public Builder processorDescription(String processorDescription) {
            this.processorDescription = processorDescription;
            this.__explicitlySet__.add("processorDescription");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder usbControllerDescription(String usbControllerDescription) {
            this.usbControllerDescription = usbControllerDescription;
            this.__explicitlySet__.add("usbControllerDescription");
            return this;
        }

        public Builder numberOfUsbControllers(Integer numberOfUsbControllers) {
            this.numberOfUsbControllers = numberOfUsbControllers;
            this.__explicitlySet__.add("numberOfUsbControllers");
            return this;
        }

        public Builder tags(String tags) {
            this.tags = tags;
            this.__explicitlySet__.add("tags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ShapeSummary build() {
            ShapeSummary model = new ShapeSummary(this.gpuDescription, this.gpus, this.memoryInGBs, this.networkingBandwidthInGbps, this.ocpus, this.processorDescription, this.shape, this.usbControllerDescription, this.numberOfUsbControllers, this.tags, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ShapeSummary model) {
            if (model.wasPropertyExplicitlySet("gpuDescription")) {
                this.gpuDescription(model.getGpuDescription());
            }
            if (model.wasPropertyExplicitlySet("gpus")) {
                this.gpus(model.getGpus());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("networkingBandwidthInGbps")) {
                this.networkingBandwidthInGbps(model.getNetworkingBandwidthInGbps());
            }
            if (model.wasPropertyExplicitlySet("ocpus")) {
                this.ocpus(model.getOcpus());
            }
            if (model.wasPropertyExplicitlySet("processorDescription")) {
                this.processorDescription(model.getProcessorDescription());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("usbControllerDescription")) {
                this.usbControllerDescription(model.getUsbControllerDescription());
            }
            if (model.wasPropertyExplicitlySet("numberOfUsbControllers")) {
                this.numberOfUsbControllers(model.getNumberOfUsbControllers());
            }
            if (model.wasPropertyExplicitlySet("tags")) {
                this.tags(model.getTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

