/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RoverWorkload
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="size")
    private final String size;
    @JsonProperty(value="objectCount")
    private final String objectCount;
    @JsonProperty(value="prefix")
    private final String prefix;
    @JsonProperty(value="rangeStart")
    private final String rangeStart;
    @JsonProperty(value="rangeEnd")
    private final String rangeEnd;
    @JsonProperty(value="workloadType")
    private final String workloadType;
    @JsonProperty(value="workRequestId")
    private final String workRequestId;

    @Deprecated
    @ConstructorProperties(value={"name", "compartmentId", "id", "size", "objectCount", "prefix", "rangeStart", "rangeEnd", "workloadType", "workRequestId"})
    public RoverWorkload(String name, String compartmentId, String id, String size, String objectCount, String prefix, String rangeStart, String rangeEnd, String workloadType, String workRequestId) {
        this.name = name;
        this.compartmentId = compartmentId;
        this.id = id;
        this.size = size;
        this.objectCount = objectCount;
        this.prefix = prefix;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.workloadType = workloadType;
        this.workRequestId = workRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getSize() {
        return this.size;
    }

    public String getObjectCount() {
        return this.objectCount;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRangeStart() {
        return this.rangeStart;
    }

    public String getRangeEnd() {
        return this.rangeEnd;
    }

    public String getWorkloadType() {
        return this.workloadType;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RoverWorkload(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", size=").append(String.valueOf(this.size));
        sb.append(", objectCount=").append(String.valueOf(this.objectCount));
        sb.append(", prefix=").append(String.valueOf(this.prefix));
        sb.append(", rangeStart=").append(String.valueOf(this.rangeStart));
        sb.append(", rangeEnd=").append(String.valueOf(this.rangeEnd));
        sb.append(", workloadType=").append(String.valueOf(this.workloadType));
        sb.append(", workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoverWorkload)) {
            return false;
        }
        RoverWorkload other = (RoverWorkload)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.size, other.size) && Objects.equals(this.objectCount, other.objectCount) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.rangeStart, other.rangeStart) && Objects.equals(this.rangeEnd, other.rangeEnd) && Objects.equals(this.workloadType, other.workloadType) && Objects.equals(this.workRequestId, other.workRequestId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.size == null ? 43 : this.size.hashCode());
        result = result * 59 + (this.objectCount == null ? 43 : this.objectCount.hashCode());
        result = result * 59 + (this.prefix == null ? 43 : this.prefix.hashCode());
        result = result * 59 + (this.rangeStart == null ? 43 : this.rangeStart.hashCode());
        result = result * 59 + (this.rangeEnd == null ? 43 : this.rangeEnd.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="size")
        private String size;
        @JsonProperty(value="objectCount")
        private String objectCount;
        @JsonProperty(value="prefix")
        private String prefix;
        @JsonProperty(value="rangeStart")
        private String rangeStart;
        @JsonProperty(value="rangeEnd")
        private String rangeEnd;
        @JsonProperty(value="workloadType")
        private String workloadType;
        @JsonProperty(value="workRequestId")
        private String workRequestId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            this.__explicitlySet__.add("size");
            return this;
        }

        public Builder objectCount(String objectCount) {
            this.objectCount = objectCount;
            this.__explicitlySet__.add("objectCount");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.__explicitlySet__.add("prefix");
            return this;
        }

        public Builder rangeStart(String rangeStart) {
            this.rangeStart = rangeStart;
            this.__explicitlySet__.add("rangeStart");
            return this;
        }

        public Builder rangeEnd(String rangeEnd) {
            this.rangeEnd = rangeEnd;
            this.__explicitlySet__.add("rangeEnd");
            return this;
        }

        public Builder workloadType(String workloadType) {
            this.workloadType = workloadType;
            this.__explicitlySet__.add("workloadType");
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            this.__explicitlySet__.add("workRequestId");
            return this;
        }

        public RoverWorkload build() {
            RoverWorkload model = new RoverWorkload(this.name, this.compartmentId, this.id, this.size, this.objectCount, this.prefix, this.rangeStart, this.rangeEnd, this.workloadType, this.workRequestId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RoverWorkload model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("size")) {
                this.size(model.getSize());
            }
            if (model.wasPropertyExplicitlySet("objectCount")) {
                this.objectCount(model.getObjectCount());
            }
            if (model.wasPropertyExplicitlySet("prefix")) {
                this.prefix(model.getPrefix());
            }
            if (model.wasPropertyExplicitlySet("rangeStart")) {
                this.rangeStart(model.getRangeStart());
            }
            if (model.wasPropertyExplicitlySet("rangeEnd")) {
                this.rangeEnd(model.getRangeEnd());
            }
            if (model.wasPropertyExplicitlySet("workloadType")) {
                this.workloadType(model.getWorkloadType());
            }
            if (model.wasPropertyExplicitlySet("workRequestId")) {
                this.workRequestId(model.getWorkRequestId());
            }
            return this;
        }
    }
}

