/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.rover.RoverEntitlement;
import com.oracle.bmc.rover.model.RoverEntitlementSummary;
import com.oracle.bmc.rover.requests.ListRoverEntitlementsRequest;
import com.oracle.bmc.rover.responses.ListRoverEntitlementsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class RoverEntitlementPaginators {
    private final RoverEntitlement client;

    public RoverEntitlementPaginators(RoverEntitlement client) {
        this.client = client;
    }

    public Iterable<ListRoverEntitlementsResponse> listRoverEntitlementsResponseIterator(final ListRoverEntitlementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRoverEntitlementsRequest.Builder>(){

            @Override
            public ListRoverEntitlementsRequest.Builder get() {
                return ListRoverEntitlementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverEntitlementsResponse, String>(){

            @Override
            public String apply(ListRoverEntitlementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverEntitlementsRequest.Builder>, ListRoverEntitlementsRequest>(){

            @Override
            public ListRoverEntitlementsRequest apply(RequestBuilderAndToken<ListRoverEntitlementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRoverEntitlementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverEntitlementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRoverEntitlementsRequest, ListRoverEntitlementsResponse>(){

            @Override
            public ListRoverEntitlementsResponse apply(ListRoverEntitlementsRequest request) {
                return RoverEntitlementPaginators.this.client.listRoverEntitlements(request);
            }
        });
    }

    public Iterable<RoverEntitlementSummary> listRoverEntitlementsRecordIterator(final ListRoverEntitlementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRoverEntitlementsRequest.Builder>(){

            @Override
            public ListRoverEntitlementsRequest.Builder get() {
                return ListRoverEntitlementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverEntitlementsResponse, String>(){

            @Override
            public String apply(ListRoverEntitlementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverEntitlementsRequest.Builder>, ListRoverEntitlementsRequest>(){

            @Override
            public ListRoverEntitlementsRequest apply(RequestBuilderAndToken<ListRoverEntitlementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRoverEntitlementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverEntitlementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRoverEntitlementsRequest, ListRoverEntitlementsResponse>(){

            @Override
            public ListRoverEntitlementsResponse apply(ListRoverEntitlementsRequest request) {
                return RoverEntitlementPaginators.this.client.listRoverEntitlements(request);
            }
        }, (Function)new Function<ListRoverEntitlementsResponse, List<RoverEntitlementSummary>>(){

            @Override
            public List<RoverEntitlementSummary> apply(ListRoverEntitlementsResponse response) {
                return response.getRoverEntitlementCollection().getItems();
            }
        });
    }
}

