/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.rover.RoverEntitlement;
import com.oracle.bmc.rover.RoverEntitlementAsyncClient;
import com.oracle.bmc.rover.RoverEntitlementPaginators;
import com.oracle.bmc.rover.RoverEntitlementWaiters;
import com.oracle.bmc.rover.model.RoverEntitlementCollection;
import com.oracle.bmc.rover.requests.ChangeRoverEntitlementCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.DeleteRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.GetRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.ListRoverEntitlementsRequest;
import com.oracle.bmc.rover.requests.UpdateRoverEntitlementRequest;
import com.oracle.bmc.rover.responses.ChangeRoverEntitlementCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.DeleteRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.GetRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.ListRoverEntitlementsResponse;
import com.oracle.bmc.rover.responses.UpdateRoverEntitlementResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverEntitlementClient
extends BaseSyncClient
implements RoverEntitlement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERENTITLEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RoverEntitlementAsyncClient.class);
    private final RoverEntitlementWaiters waiters;
    private final RoverEntitlementPaginators paginators;

    private RoverEntitlementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("RoverEntitlement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RoverEntitlementWaiters(executorService, this);
        this.paginators = new RoverEntitlementPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeRoverEntitlementCompartmentResponse changeRoverEntitlementCompartment(ChangeRoverEntitlementCompartmentRequest request) {
        Validate.notBlank((String)request.getRoverEntitlementId(), (String)"roverEntitlementId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRoverEntitlementCompartmentDetails(), "changeRoverEntitlementCompartmentDetails is required");
        return (ChangeRoverEntitlementCompartmentResponse)this.clientCall(request, ChangeRoverEntitlementCompartmentResponse::builder).logger(LOG, "changeRoverEntitlementCompartment").serviceDetails("RoverEntitlement", "ChangeRoverEntitlementCompartment", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/ChangeRoverEntitlementCompartment").method(Method.POST).requestBuilder(ChangeRoverEntitlementCompartmentRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendPathParam(request.getRoverEntitlementId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRoverEntitlementCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateRoverEntitlementResponse createRoverEntitlement(CreateRoverEntitlementRequest request) {
        Objects.requireNonNull(request.getCreateRoverEntitlementDetails(), "createRoverEntitlementDetails is required");
        return (CreateRoverEntitlementResponse)this.clientCall(request, CreateRoverEntitlementResponse::builder).logger(LOG, "createRoverEntitlement").serviceDetails("RoverEntitlement", "CreateRoverEntitlement", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/CreateRoverEntitlement").method(Method.POST).requestBuilder(CreateRoverEntitlementRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.rover.model.RoverEntitlement.class, CreateRoverEntitlementResponse.Builder::roverEntitlement).handleResponseHeaderString("opc-request-id", CreateRoverEntitlementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateRoverEntitlementResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteRoverEntitlementResponse deleteRoverEntitlement(DeleteRoverEntitlementRequest request) {
        Validate.notBlank((String)request.getRoverEntitlementId(), (String)"roverEntitlementId must not be blank", (Object[])new Object[0]);
        return (DeleteRoverEntitlementResponse)this.clientCall(request, DeleteRoverEntitlementResponse::builder).logger(LOG, "deleteRoverEntitlement").serviceDetails("RoverEntitlement", "DeleteRoverEntitlement", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/DeleteRoverEntitlement").method(Method.DELETE).requestBuilder(DeleteRoverEntitlementRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendPathParam(request.getRoverEntitlementId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteRoverEntitlementResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRoverEntitlementResponse getRoverEntitlement(GetRoverEntitlementRequest request) {
        Validate.notBlank((String)request.getRoverEntitlementId(), (String)"roverEntitlementId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetRoverEntitlementResponse)this.clientCall(request, GetRoverEntitlementResponse::builder).logger(LOG, "getRoverEntitlement").serviceDetails("RoverEntitlement", "GetRoverEntitlement", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/GetRoverEntitlement").method(Method.GET).requestBuilder(GetRoverEntitlementRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendPathParam(request.getRoverEntitlementId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.rover.model.RoverEntitlement.class, GetRoverEntitlementResponse.Builder::roverEntitlement).handleResponseHeaderString("opc-request-id", GetRoverEntitlementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRoverEntitlementResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListRoverEntitlementsResponse listRoverEntitlements(ListRoverEntitlementsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRoverEntitlementsResponse)this.clientCall(request, ListRoverEntitlementsResponse::builder).logger(LOG, "listRoverEntitlements").serviceDetails("RoverEntitlement", "ListRoverEntitlements", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/ListRoverEntitlements").method(Method.GET).requestBuilder(ListRoverEntitlementsRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverEntitlementCollection.class, ListRoverEntitlementsResponse.Builder::roverEntitlementCollection).handleResponseHeaderString("opc-request-id", ListRoverEntitlementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoverEntitlementsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListRoverEntitlementsResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateRoverEntitlementResponse updateRoverEntitlement(UpdateRoverEntitlementRequest request) {
        Validate.notBlank((String)request.getRoverEntitlementId(), (String)"roverEntitlementId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRoverEntitlementDetails(), "updateRoverEntitlementDetails is required");
        return (UpdateRoverEntitlementResponse)this.clientCall(request, UpdateRoverEntitlementResponse::builder).logger(LOG, "updateRoverEntitlement").serviceDetails("RoverEntitlement", "UpdateRoverEntitlement", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverEntitlement/UpdateRoverEntitlement").method(Method.PUT).requestBuilder(UpdateRoverEntitlementRequest::builder).basePath("/20201210").appendPathParam("roverEntitlements").appendPathParam(request.getRoverEntitlementId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.rover.model.RoverEntitlement.class, UpdateRoverEntitlementResponse.Builder::roverEntitlement).handleResponseHeaderString("etag", UpdateRoverEntitlementResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRoverEntitlementResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RoverEntitlementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RoverEntitlementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public RoverEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RoverEntitlementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RoverEntitlementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RoverEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RoverEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RoverEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RoverEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RoverEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverEntitlementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RoverEntitlementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RoverEntitlementClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

